<?php
include_once(dirname(__FILE__) . '/class/include.php');

$id = '';

if (isset($_GET['id'])) {
    $id = $_GET['id'];
}

$EVENT = new Events($id);

$events = $EVENT->all();
?>

<!DOCTYPE html>
<html>

    <head>
        <meta charset="utf-8">
        <title>Women's Development Federation | <?php echo $EVENT->title; ?></title>
        <!-- Stylesheets -->
        <link href="images/icons/favicon.png" rel="icon" sizes="32x32" type="image/png">
        <link href="css/bootstrap.css" rel="stylesheet">
        <link href="css/style.css" rel="stylesheet">
        <!-- Responsive -->
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">
        <link href="css/responsive.css" rel="stylesheet">
        <!--[if lt IE 9]><script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script><![endif]-->
        <!--[if lt IE 9]><script src="js/respond.js"></script><![endif]-->
    </head>

    <body>
        <div class="page-wrapper">

            <!-- Main Header -->
            <?php
            include 'header.php';
            ?>
            <!--End Main Header -->


            <!--Page Title-->
            <section class="page-title" style="background-image:url(images/background/page-title-bg.jpg);">
                <div class="auto-container">
                    <div class="sec-title">
                        <h1>View Event</h1>
                        <div class="bread-crumb"><a href="./">Home</a> / <a href="events.php">Events</a> / <?php echo $EVENT->title; ?></div>
                    </div>
                </div>
            </section>


            <!--Sidebar Page-->
            <div class="sidebar-page">
                <div class="auto-container">
                    <div class="row clearfix">

                        <!--Content Side-->	
                        <div class="col-lg-9 col-md-8 col-sm-12 col-xs-12">

                            <!--Projects Section-->
                            <section class="events-section event-details no-padd-bottom no-padd-top padd-right-20">

                                <div class="column default-featured-column style-two">
                                    <article class="inner-box">
                                        <figure class="event-carousel">
                                            <?php
                                            $photos = EventsPhoto::getEventsPhotosById($EVENT->id);
                                            foreach ($photos as $photo) {
                                                ?>
                                            <img src="upload/event/gallery/<?php echo $photo['image_name'] ?>" alt="">
                                                <?php
                                            }
                                            ?>
                                        </figure>
                                        <div class="content-box padd-top-40">
                                            <div class="row detail-header clearfix">
                                                <div class="col-md-8 col-sm-12">
                                                    <h3 class="fs-28"><?php echo $EVENT->title; ?></h3>
                                                    <ul class="event-held list-inline">
                                                        <li class="theme_color "><i class="black_color fa fa-calendar-o tp-mr5"></i> <?php echo $EVENT->date; ?></li>
                                                        <li class="theme_color "> <i class="black_color fa fa-map-marker tp-mr5"></i><?php echo $EVENT->venue; ?></li>
                                                    </ul>
                                                </div>
                                                <div class="col-md-4 col-sm-12 pull-right text-right"><a href="become-volunteer.php" class="theme-btn btn-style-two">Join With Us</a></div>
                                            </div>
                                            <hr>

                                            <div class="text">
                                                <p><?php echo $EVENT->description; ?></p>
                                            </div>

                                        </div>
                                    </article>
                                </div>

                            </section>

                        </div>
                        <!--Content Side-->

                        <!--Sidebar-->	
                        <div class="col-lg-3 col-md-4 col-sm-12 col-xs-12">
                            <aside class="sidebar">

                                <!-- Recent Posts -->
                                <div class="widget recent-posts wow fadeInUp" data-wow-delay="0ms" data-wow-duration="1500ms">
                                    <div class="sidebar-title"><h3>Other Events</h3></div>
                                    <?php
                                    foreach ($events as $event) {
                                        ?>
                                        <article class="post">
                                            <figure class="post-thumb">
                                                <a href="view-event.php?id=<?php echo $event['id']; ?>"><img src="upload/event/<?php echo $event['image_name']; ?>" alt=""></a>
                                            </figure>
                                            <h4><a href="view-event.php?id=<?php echo $event['id']; ?>"><?php echo substr($event['title'], 0, 15) . '...'; ?></a></h4>
                                            <div class="post-info"><span class="fa fa-calendar"></span> <?php echo $event['date']; ?></div>
                                            <div class="post-info"><span class="fa fa-map-marker"></span> <?php echo $event['venue']; ?></div>
                                        </article>
                                        <?php
                                    }
                                    ?>

                                </div>

                            </aside>


                        </div>
                        <!--Sidebar-->


                    </div>
                </div>
            </div>

            <!--Main Footer-->
            <?php
            include 'footer.php';
            ?>
            <!--Main Footer-->


        </div>
        <!--End pagewrapper-->


        <!--Scroll to top-->
        <div class="scroll-to-top scroll-to-target" data-target=".page-wrapper"><span class="fa fa-long-arrow-up"></span></div>


        <script src="js/jquery.js"></script> 
        <script src="js/bootstrap.min.js"></script>
        <script src="js/jquery.bxslider.min.js"></script>
        <script src="js/jquery.fancybox.pack.js"></script>
        <script src="js/jquery.fancybox-media.js"></script>
        <script src="js/owl.js"></script>
        <script src="js/map-script.js"></script>
        <script src="js/wow.js"></script>
        <script src="js/script.js"></script>

        <script type="text/javascript">
            $(document).ready(function () {
                $(".event-carousel").owlCarousel({
                    loop: true,
                    margin: 7,
                    nav: false,
                    autoplay: true,
                    autoplayTimeout: 2000,
                    autoplayHoverPause: true,
                    dots: false,
                    responsive: {
                        0: {
                            items: 1
                        },
                        600: {
                            items: 1
                        },
                        1000: {
                            items: 1
                        }
                    }
                });
            });
        </script>
    </body>

</html>