<?php
include_once(dirname(__FILE__) . '/class/include.php');

$PORTFOLIO = new Portfolio(Null);
?>

<!DOCTYPE html>
<html>

<head>
<meta charset="utf-8">
<title>Women's Development Federation | Our Projects</title>
<!-- Stylesheets -->
<link href="images/icons/favicon.png" rel="icon" sizes="32x32" type="image/png">
<link href="css/bootstrap.css" rel="stylesheet">
<link rel="stylesheet" href="../../../code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
<link href="css/style.css" rel="stylesheet">
<!-- Responsive -->
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">
<link href="css/responsive.css" rel="stylesheet"`>
<!--[if lt IE 9]><script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script><![endif]-->
<!--[if lt IE 9]><script src="js/respond.js"></script><![endif]-->
</head>

<body>
<div class="page-wrapper">

    <!-- Main Header -->
    <?php
    include 'header.php';
    ?>
    <!--End Main Header -->
    
    
    <!--Page Title-->
    <section class="page-title" style="background-image:url(images/background/page-title-bg.jpg);">
    	<div class="auto-container">
        	<div class="sec-title">
                <h1>Our Projects</h1>
                <div class="bread-crumb"><a href="./">Home</a> / Our Projects</div>
            </div>
        </div>
    </section>
    
    
    <!--Events Section-->
    <section class="events-section latest-events">
    	<div class="auto-container">
        	
            <!--Filters Section-->
        	<div class="row clearfix events-list-section">
                
                <?php
                        foreach ($PORTFOLIO->all() as $key=> $portfolio) {
                                ?>
                                <div class="column default-featured-column style-two col-lg-4 col-md-4 col-sm-6 col-xs-12">
                                    <article class="" data-wow-delay="900ms" data-wow-duration="1500ms">
                                        <figure class="image-box">
                                            <a href="view-project.php?id=<?php echo $portfolio["id"];?>"><img src="upload/portfolio/<?php echo $portfolio['image_name'] ?>" alt=""></a>
<!--                                            <div class="post-tag"><?php // echo $portfolio['date'] ?></div>-->
                                        </figure>
                                        <div class="content-box">
                                            <h3><a href="view-project.php?id=<?php echo $portfolio["id"];?>"><?php echo $portfolio['title'] ?></a></h3>
                                            <div class="text"><?php echo substr($portfolio['short_description'], 0, 70) . '...'; ?></div>
                                            <a href="view-project.php?id=<?php echo $portfolio["id"];?>" class="theme-btn btn-style-two btn-sm">Read More</a>
                                            <a href="become-volunteer.php" class="theme-btn btn-style-four btn-sm">Join With Us</a>
                                        </div>
                                    </article>
                                </div>
                                <?php
                        }
                        ?>
                
            </div>
            
                        
        </div>
    </section>

    
    <!--Main Features-->
    
    <!--Main Footer-->
    <?php
    include 'footer.php';
    ?>
    <!--End Main Footer-->
    
</div>
<!--End pagewrapper-->


<!--Scroll to top-->
<div class="scroll-to-top scroll-to-target" data-target=".page-wrapper"><span class="fa fa-long-arrow-up"></span></div>


<script src="js/jquery.js"></script> 
<script src="js/bootstrap.min.js"></script>
<script src="js/jquery.fancybox.pack.js"></script>
<script src="js/jquery.fancybox-media.js"></script>
<script src="../../../code.jquery.com/jquery-1.10.2.js"></script>
<script src="../../../code.jquery.com/ui/1.11.4/jquery-ui.js"></script>
<script src="js/owl.js"></script>
<script src="js/wow.js"></script>
<script src="js/jquery.bxslider.min.js"></script>
<script src="js/script.js"></script>
</body>

</html>