<?php
include './db.php';
include './main-functions.php';

$sliderPhotos = getMainSliderPhotos();

$settings = getSliderSettings();

$gallery = getAllAlbums();

$details = getAboutUsPageContents();

$team = getTeam();

$services = getServices();

$packages = getPricePackages();
?>

<!DOCTYPE html>
<html lang="en"> 
    <meta http-equiv="content-type" content="text/html;charset=utf-8" /><!-- /Added by HTTrack -->
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>The Garden Hotel - Unawatuan</title>

        <!-- Bootstrap CSS -->
        <link href="css/bootstrap.css" rel="stylesheet">

        <!-- Font Awesome CSS -->
        <link href="css/font-awesome.min.css" rel="stylesheet">
        <link href="fonts/themify-icons.css" rel="stylesheet">

        <!-- Owl Carousel CSS -->
        <link href="css/owl.carousel.css" rel="stylesheet">

        <!-- Magnific Popup core CSS file -->
        <link rel="stylesheet" href="css/magnific-popup.css"> 

        <!-- Animate CSS -->
        <link rel="stylesheet" href="css/animate.css"> 


        <!-- Theme CSS -->
        <link href="css/style.css" rel="stylesheet">

        <!-- Google Fonts -->
        <link href='http://fonts.googleapis.com/css?family=Open+Sans:400,300,600,700' rel='stylesheet' type='text/css'>
        <link href='http://fonts.googleapis.com/css?family=Oswald:400,700,300' rel='stylesheet' type='text/css'>


    </head>
    <body class="passp_black">


        <div class="passpartu passpartu_left"></div>
        <div class="passpartu passpartu_right"></div>
        <div class="passpartu passpartu_top"></div>
        <div class="passpartu passpartu_bottom"></div>

        <div class="page" id="page">


            <!-- Header -->
            <header class="no_border">


                <!-- Logo -->
                <div class="logo pull-left">
                    <a href="#">
                        <img src="images/seven-star-studio-holdings-logo.png" alt="seven-star-studio-holdings-logo"/>
                    </a>
                </div>


                <!-- Header Buttons -->
                <div class="header_btns_wrapper">

                    <!-- Main Menu Btn -->
                    <div class="main_menu"><i class="ti-menu"></i><i class="ti-close"></i></div>

                    <!-- Sub Menu -->
                    <div class="sub_menu">
                        <div class="sub_cont">
                            <ul>
                                <li><a href="#home">Home</a></li>
                                <li><a href="#about-us">About Us</a></li>
                                <li><a href="#services">Services</a></li>
                                <li><a href="#gallery">Gallery</a></li>
                                <li><a href="#menus">Our Menus</a></li> 
                                <li><a href="#contacts">Contacts</a></li> 
                            </ul>


                        </div>
                    </div>
                    <!-- Sub Menu End -->

                </div>
                <!-- Header Buttons End -->

                <!-- Up Arrow -->
                <a href="#about-us" class="up_block go"><i class="fa fa-angle-up"></i></a>

            </header>
            <!-- Header End -->


            <!-- Intro-->
            <section class="intro" id="home"> 
                <!-- Down Arrow -->
                <a href="#about-us" class="down_block go"><i class="fa fa-angle-down"></i></a> 
                <!-- Wrapper-->     
                <div class="intro_wrapper"> 
                    <?php
                    foreach ($sliderPhotos as $key => $photo) {
                        $key = $key + 1;
                        ?>
                        <div class="intro_item"> 
                            <div class="over" data-opacity="1" data-color=""></div> 
                            <div class="into_back image_bck" data-image="images/slider/<?php echo $photo['image_name']; ?>"></div> 

                            <div class="text_content">      
                                <div class="intro_text intro_text_rc text-left text_up"> 
                                    <span class="great_subtitle great_subtitle_big" style="margin: -100px 0px 0px 0px;">
                                        <img src="images/slider/<?php echo $key; ?>/1.png"/>
                                    </span> 
                                    <span class="great_subtitle great_subtitle_big">
                                        <img src="images/slider/<?php echo $key; ?>/4.png" style="margin: -180px 1px 1px -180px;"/>
                                    </span>
                                    <span class="great_subtitle great_subtitle_big">
                                        <img src="images/slider/<?php echo $key; ?>/6.png" style="margin: -70px 300px 100px 0px;"/>
                                    </span>
                                    <span class="great_subtitle great_subtitle_big">
                                        <img src="images/slider/<?php echo $key; ?>/7.png" style="margin: -750px 300px 100px 180px;"/>
                                    </span> 
                                    <span class="great_subtitle great_subtitle_big">
                                        <img src="images/slider/<?php echo $key; ?>/2.png" style="margin: -900px 1px 1px -100px;"/>
                                    </span> 
                                    <span class="great_subtitle great_subtitle_big">
                                        <img src="images/slider/<?php echo $key; ?>/5.png" style="margin: -980px 300px 100px 50px;"/>
                                    </span>
                                </div>               

                            </div>
                        </div> 
                        <?php
                    }
                    ?>  
                </div>



                <!-- Wrapper End--> 
            </section>
            <!-- Intro End-->


            <!-- Slider Border -->
            <div class="after_slider_border"></div>  

            <section class="boxes" id="about-us" >
                <div class="container-fluid">

                    <div class="row">

                        <div class="col-md-12 bordered_block image_bck bordered_wht_border white_txt text-center" data-image="images/wedding2.jpg" style="background-image: url(&quot;images/wedding2.jpg&quot;);">
                            <div   data-opacity="0.8" data-color="rgba(0, 0, 0, 0.9)" style="opacity: 0.8; background-color: rgba(142, 120, 40, 0.901961); width: 100%; height: 100%; top: 0; left: 0; position: absolute; z-index: 1;"></div>
                            <div class="container">
                                <h3><?php echo $details['title']; ?> </h3>
                                <?php echo $details['details']; ?> 

                                <h3 style="margin-top: 30px;">Our Team</h3>
                                <div class="mid_wrapper"> 
                                    <?php
                                    if (count($team) > 0) {
                                        foreach ($team as $member) {
                                            ?>

                                            <div class="bordered_block flex_block image_bck bordered_zoom bordered_zoom_three bordered_zoom_gold height400">
                                                <div class="image_over image_bck" data-image="images/team/<?php echo $member["photo"]; ?>" style="background-image: url(&quot;images/<?php echo $member["photo"]; ?>&quot;);"></div>
                                                <div class="box_content">
                                                    <h3><?php echo $member["name"]; ?></h3>
                                                    <b><?php echo $member["designation"]; ?></b>
                                                    <br/>
                                                    <div class="text-justify">
                                                        <?php echo $member["details"]; ?>  
                                                    </div>
                                                </div>     
                                            </div>  


                                            <?php
                                        }
                                    } else {
                                        ?> 
                                        <b>No Members in the database.</b> 
                                    <?php } ?>  
                                </div>
                            </div>
                        </div>  
                    </div>

                    <!-- Row End -->
                </div>
            </section>

            <div class="after_slider_border"></div>

            <!-- Our Services-->
            <section class="boxes" id="services">
                <div class="container-fluid">


                    <div class="row">

                        <div class="col-md-12 bordered_block grey_border image_bck" data-image="images/white_back.jpg" style="border-top: 3px; border-bottom: 3px;">
                            <div class="container">
                                <h3 class="text-center">Our Services</h3> 
                                <!-- Wrapper-->
                                <div class="mid_wrapper"> 
                                    <?php
                                    if (count($services) > 0) {
                                        foreach ($services as $service) {
                                            ?>

                                            <div class="mid_box  text-center">
                                                <div class="icon">
                                                    <span class="<?php echo $service["icon"]; ?>"></span>
                                                </div>
                                                <h5><?php echo $service["name"]; ?></h5>
                                                <p style="text-align: justify !important;">
                                                    <?php echo $service["details"]; ?>
                                                </p>
                                            </div> 

                                            <?php
                                        }
                                    } else {
                                        ?> 
                                        <b>No Services in the database.</b> 
                                    <?php } ?> 

                                </div>
                                <!-- Wrapper End-->

                            </div>

                        </div>
                    </div>
                    <!-- Row End-->

                </div>
            </section>
            <!-- Our Services End-->



            <div class="after_slider_border"></div>

            <section class="boxes" id="gallery"> 

                <div class="container-fluid">
                    <h3 class="text-center" style="color: white; margin: 21px 0px 0px 0px;">Photo Gallery</h3>
                    <div class="masonry row" style="position: relative; height: 843px;">

                        <?php
                        if (count($gallery) > 0) {
                            foreach ($gallery as $img) {
                                ?>

                                <div class="col-sm-3 post-snippet masonry-item" style="position: absolute; left: 386px; top: 10px;">
                                    <a href="view-album.php?album=<?php echo $img["id"]; ?>" title="<?php echo $img["name"]; ?>">
                                        <img alt="" src="images/photo-albums/<?php echo $img["photo"]; ?>">
                                        <span class="potfolio_txt">
                                            <span class="portfolio_cont text-center">
                                                <span class="portfolio_title">
                                                    <?php echo $img["name"]; ?>
                                                </span>

                                                <span class="ti ti-zoom-in"></span>
                                            </span>
                                        </span>
                                    </a>
                                </div>

                                <?php
                            }
                        } else {
                            ?> 
                            <b>No images in the database.</b> 
                        <?php } ?> 



                    </div>
                    <div class="text-center" style="margin: 10px 0px 50px 1px;"> 
                    </div>
                </div>
            </section>

            <!-- Price-->
            <section class="boxes" id="menus">
                <div class="container-fluid">

                    <div class="row">

                        <div class="col-md-12 bordered_block image_bck bordered_wht_border white_txt" data-image="images/photo5.jpg"  style="border-top: 0px; border-bottom: 0px;">

                            <!-- Over-->
                            <div class="over" data-opacity="0.5" data-color="#000"></div>

                            <div class="container">

                                <h3 class="text-center" style="color: white;">Our Wedding Menu</h3>

                                <div class="mid_wrapper row">

                                    <div class="mid_box"> 
                                        <!-- Item-->           
                                        <div class="text-center"  style="padding: 5px; border: solid 1px white;">
                                            <a href="images/menus/1.jpg" class="menubox" style="width: 100%" >
                                                <img alt="" src="images/menus/thumb/1.jpg" style="width: 100%">
                                                <span class="potfolio_txt">
                                                    <span class="portfolio_cont text-center">
                                                        <span class="portfolio_title">
                                                            Menu - 01
                                                        </span>

                                                        <span class="ti ti-zoom-in"></span>
                                                    </span>
                                                </span>
                                            </a>
                                        </div>

                                    </div> 

                                    <div class="mid_box"> 
                                        <!-- Item-->           
                                        <div class="text-center"  style="padding: 5px; border: solid 1px white;">
                                            <a href="images/menus/2.jpg" class="menubox" style="width: 100%" >
                                                <img alt="" src="images/menus/thumb/2.jpg" style="width: 100%">
                                                <span class="potfolio_txt">
                                                    <span class="portfolio_cont text-center">
                                                        <span class="portfolio_title">
                                                            Menu - 02
                                                        </span>

                                                        <span class="ti ti-zoom-in"></span>
                                                    </span>
                                                </span>
                                            </a>
                                        </div>

                                    </div> 

                                    <div class="mid_box"> 
                                        <!-- Item-->           
                                        <div class="text-center"  style="padding: 5px; border: solid 1px white;">
                                            <a href="images/menus/3.jpg" class="menubox" style="width: 100%" >
                                                <img alt="" src="images/menus/thumb/3.jpg" style="width: 100%">
                                                <span class="potfolio_txt">
                                                    <span class="portfolio_cont text-center">
                                                        <span class="portfolio_title">
                                                            Menu - 03
                                                        </span>

                                                        <span class="ti ti-zoom-in"></span>
                                                    </span>
                                                </span>
                                            </a>
                                        </div>

                                    </div> 

                                    <div class="mid_box"> 
                                        <!-- Item-->           
                                        <div class="text-center"  style="padding: 5px; border: solid 1px white;">
                                            <a href="images/menus/4.jpg" class="menubox" style="width: 100%" >
                                                <img alt="" src="images/menus/thumb/4.jpg" style="width: 100%">
                                                <span class="potfolio_txt">
                                                    <span class="portfolio_cont text-center">
                                                        <span class="portfolio_title">
                                                            Menu - 04
                                                        </span>

                                                        <span class="ti ti-zoom-in"></span>
                                                    </span>
                                                </span>
                                            </a>
                                        </div>

                                    </div> 


                                </div>
                                <!-- Row End-->

                                <div class="text-center" style="margin: 70px 0px 50px 1px;">
                                    <a class="btn btn-white" href="menu.php">View Menu</a>
                                </div>
                            </div>

                        </div>
                    </div>
                    <!-- Row End-->


                </div>
            </section>
            <!-- Price End-->

            <!-- Contacts -->
            <section class="boxes" id="contacts">
                <div class="container-fluid"> 
                    <h3 class="text-center" style="color: white; margin: 40px 0px 0px 0px;">Contact Us</h3>
                    <div class="row">
                        <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d828.4001575426238!2d80.27122130000001!3d5.9996581!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x657b27e556033938!2sThe+Garden!5e0!3m2!1sen!2slk!4v1476250697656" width="100%" height="450" frameborder="0" style="border:0" allowfullscreen></iframe>

                        <!-- Contacts -->
                        <div class="col-md-6 bordered_block image_bck bordered_wht_border white_txt" data-image="images/hotel_c1.jpg" style="border-right: 10px solid black;">
                            <div class="over" data-opacity="0.6" data-color="#292929"></div>
                            <div class="col-md-12 simple_block text-left">
                                <h3>Details</h3>
                                <span class="contacts_ti ti-mobile"></span>077 351 0188<br />
                                <span class="contacts_ti ti-mobile"></span>091 492 3688<br />
                                <span class="contacts_ti ti-email"></span><a >sajeewan1972@gmail.com</a><br />
                                <span class="contacts_ti ti-location-pin"></span>
                                The Garden Hotel, Mihiripanna, Unawatuna.

                                <div id="fb-root"></div>
                                <script>
                                    (function (d, s, id) {
                                        var js, fjs = d.getElementsByTagName(s)[0];
                                        if (d.getElementById(id))
                                            return;
                                        js = d.createElement(s);
                                        js.id = id;
                                        js.src = "//connect.facebook.net/en_US/sdk.js#xfbml=1&version=v2.8";
                                        fjs.parentNode.insertBefore(js, fjs);
                                    }(document, 'script', 'facebook-jssdk'));
                                </script>
                                <div class="fb-page" data-href="https://www.facebook.com/thegardensrilanka" data-small-header="false" data-adapt-container-width="true" data-hide-cover="false" data-show-facepile="true"><blockquote cite="https://www.facebook.com/thegardensrilanka" class="fb-xfbml-parse-ignore"><a href="https://www.facebook.com/thegardensrilanka">TheGarden Sri Lanka</a></blockquote></div> 
                            </div>    
                        </div>

                        <!-- Write Us -->
                        <div class="col-md-6 bordered_block image_bck bordered_wht_border white_txt" data-image="images/hotel_c2.jpg">
                            <div class="over" data-opacity="0.6" data-color="#292929"></div>
                            <div class="col-md-12 simple_block text-left">
                                <h3>Contact Form</h3>
                                <form id="write_us" class="form">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <input type="text" id="name" class="form-control form-opacity" placeholder="Name*">
                                        </div>
                                        <div class="col-md-6">
                                            <input type="text" id="surname" class="form-control form-opacity" placeholder="Surname*">
                                        </div>
                                        <div class="col-md-6">
                                            <input type="text" id="city" class="form-control form-opacity" placeholder="City">
                                        </div>
                                        <div class="col-md-6">
                                            <input type="text" id="country" class="form-control form-opacity" placeholder="Country">
                                        </div>
                                        <div class="col-md-6">
                                            <input type="text" id="email" class="form-control form-opacity" placeholder="E-mail*">
                                        </div>
                                        <div class="col-md-6">
                                            <input type="text" id="phone" class="form-control form-opacity" placeholder="Phone">
                                        </div>
                                        <div class="col-md-12">
                                            <textarea placeholder="Message" id="message" class="form-control form-opacity"></textarea>
                                        </div>
                                        <div class="col-md-12">
                                            <input type="submit" class="btn btn-white submit" value="Send">
                                        </div>
                                    </div>
                                </form>
                            </div>   
                        </div>
                        <!-- Write Us End -->

                    </div>
                    <!-- Row End -->
                </div>
            </section>
            <!-- Contacts End -->

            <!-- Footer -->
            <?php include './footer.php'; ?>
            <!-- Footer End -->


        </div>
        <!-- Page End -->



        <!-- JQuery -->
        <script src="js/jquery-1.11.3.min.js"></script> 
        <!-- WL Carousel JS -->
        <script src="js/owl.carousel.min.js"></script>

        <!-- PrefixFree -->
        <script src="js/prefixfree.min.js"></script>
        <!-- Magnific Popup core JS file -->
        <script src="js/jquery.magnific-popup.min.js"></script>
        <!-- Textillate -->
        <script src="js/jquery.lettering.js"></script>
        <!-- Countdown -->
        <script src="js/jquery.plugin.min.js"></script> 
        <script src="js/jquery.countdown.min.js"></script>
        <!-- JQuery UI -->
        <script src="js/jquery-ui.js"></script>
        <!-- Wow -->
        <script src="js/wow.js"></script>
        <!-- Masonry -->
        <script src="js/masonry.pkgd.min.js"></script>

        <!-- Bootstrap JS -->
        <script src="js/bootstrap.min.js"></script>
        <!-- Theme JS -->
        <script src="js/script.js"></script>


    </body> 
</html>
text" id="surname" class="form-control form-opacity" placeholder="Surname*">
                                        </div>
                                        <div class="col-md-6">
                                            <input type="text" id="city" class="form-control form-opacity" placeholder="City">
                                        </div>
                                        <div class="col-md-6">
                                            <input type="text" id="country" class="form-control form-opacity" placeholder="Country">
                                        </div>
                                        <div class="col-md-6">
                                            <input type="text" id="email" class="form-control form-opacity" placeholder="E-mail*">
                                        </div>
                                        <div class="col-md-6">
                                            <input type="text" id="phone" class="form-control form-opacity" placeholder="Phone">
                                        </div>
                                        <div class="col-md-12">
                                            <textarea placeholder="Message" id="message" class="form-control form-opacity"></textarea>
                                        </div>
                                        <div class="col-md-12">
                                            <input type="submit" class="btn btn-white submit" value="Send">
                                        </div>
                                    </div>
                                </form>
                            </div>   
                        </div>
                        <!-- Write Us End -->

                    </div>
                    <!-- Row End -->
                </div>
            </section>
            <!-- Contacts End -->

            <!-- Footer -->
            <?php include './footer.php'; ?>
            <!-- Footer End -->


        </div>
        <!-- Page End -->



        <!-- JQuery -->
        <script src="js/jquery-1.11.3.min.js"></script> 
        <!-- WL Carousel JS -->
        <script src="js/owl.carousel.min.js"></script>

        <!-- PrefixFree -->
        <script src="js/prefixfree.min.js"></script>
        <!-- Magnific Popup core JS file -->
        <script src="js/jquery.magnific-popup.min.js"></script>
        <!-- Textillate -->
        <script src="js/jquery.lettering.js"></script>
        <!-- Countdown -->
        <script src="js/jquery.plugin.min.js"></script> 
        <script src="js/jquery.countdown.min.js"></script>
        <!-- JQuery UI -->
        <script src="js/jquery-ui.js"></script>
        <!-- Wow -->
        <script src="js/wow.js"></script>
        <!-- Masonry -->
        <script src="js/masonry.pkgd.min.js"></script>

        <!-- Bootstrap JS -->
        <script src="js/bootstrap.min.js"></script>
        <!-- Theme JS -->
        <script src="js/script.js"></script>


    </body> 
</html>
