<!DOCTYPE html>

<?php
include './class/include.php';
if (!isset($_SESSION)) {
    session_start();
}
$get_cat = null;
$get_brand = null;
$get_subcat = null;
$title = 'All Products';
$products = Product::all();
if (isset($_GET['cat'])) {
    $get_cat = $_GET['cat'];
    $CAT = new ProductCategories($_GET['cat']);
    $title = $CAT->name;
    $products = Product::getProductsByCategory($get_cat);
}
if (isset($_GET['subcat'])) {
    $get_subcat = $_GET['subcat'];
    $SUBCAT = new SubCategory($_GET['subcat']);
    $title = $SUBCAT->name;
    $products = Product::getProductsBySubCategory($get_subcat);
}
if (isset($_GET['brand'])) {
    $get_brand = $_GET['brand'];
    $BRAND = new Brand($_GET['brand']);
    $title = $BRAND->name;
    $products = Product::getProductsByBrand($get_brand);
}

if (isset($_GET["page"])) {
    $page = (int) $_GET["page"];
} else {
    $page = 1;
}
$setlimit = 21;

$pagelimit = ($page * $setlimit) - $setlimit;
$OFFER = new Offer(NULL);
$BORD1 = new Banner(1);
$BORD2 = new Banner(2);
?>

<html lang="en">


    <head>
        <meta charset="UTF-8"/>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <link rel="shortcut icon" type="image/x-icon" href="assets/magnoliya logo.png"/>
        <link href="https://fonts.googleapis.com/css2?family=Manrope:wght@200;300;400;500;600;700;800&amp;display=swap" rel="stylesheet">
        <link href="https://fonts.googleapis.com/css2?family=Kaushan+Script&amp;display=swap" rel="stylesheet">
        <link rel="stylesheet" type="text/css" href="assets/css/bootstrap.min.css"/>
        <link rel="stylesheet" type="text/css" href="assets/css/animate.css"/>
        <link rel="stylesheet" type="text/css" href="assets/css/bootstrap.min.css"/>
        <link rel="stylesheet" type="text/css" href="assets/css/chosen.min.css"/>
        <link rel="stylesheet" type="text/css" href="assets/css/font-awesome.min.css"/>
        <link rel="stylesheet" type="text/css" href="assets/css/pe-icon-7-stroke.css"/>
        <link rel="stylesheet" type="text/css" href="assets/css/jquery.scrollbar.css"/>
        <link rel="stylesheet" type="text/css" href="assets/css/lightbox.min.css"/>
        <link rel="stylesheet" type="text/css" href="assets/css/magnific-popup.css"/>
        <link rel="stylesheet" type="text/css" href="assets/css/slick.min.css"/>
        <link rel="stylesheet" type="text/css" href="assets/fonts/flaticon.css"/>
        <link rel="stylesheet" type="text/css" href="assets/css/megamenu.css"/>
        <link rel="stylesheet" type="text/css" href="assets/css/dreaming-attribute.css"/>
        <link rel="stylesheet" type="text/css" href="assets/css/style.css"/>
        <title>Magnoliya</title>
    </head>
    <body>
        <!-- Start Header -->
        <?php include './header.php'; ?>
        <!-- End Header -->

        <div class="fullwidth-template">

            <!-- Start slider -->
            <?php include './slider.php'; ?>
            <!-- End slider -->

            <div class="section-001 section-004">
                <div class="container">
                    <div class="row">
                        <?php
                        $BORD = new Banner(NULL);
                        foreach ($BORD->all() as $key => $bord) {

                            if ($key > 1) {
                                break;
                            }
                            ?>
                            <div class="col-md-12 col-lg-6">
                                <div class="lynessa-banner style-04 left-center">
                                    <div class="banner-inner">
                                        <figure class="banner-thumb">
                                            <img src="upload/banner/<?php echo $bord['image_name']; ?>"
                                                 class="attachment-full size-full" alt="img">
                                        </figure>
                                        <div class="banner-info ">
                                            <div class="banner-content banner-padding">
                                                <div class="title-wrap">
                                                    <h6 class="title"><?php echo $bord['title']; ?></h6>
                                                </div>
                                                <!--<div class="cate">Selling</div>-->
                                                <div class="button-wrap banner-btn">
    <!--                                                    <div class="subtitle"><?php echo $bord['title']; ?></div>-->
                                                    <a class="button" target="_self" href="designs.php"><span>Shop now</span></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php
                        }
                        ?> 
                    </div>
                </div>
            </div>

            <div class="section-011">
                <div class="container">
                    <div class="lynessa-heading style-01">
                        <div class="heading-inner">
                            <h3 class="title">
                                New Arrival <span></span> </h3>

                        </div>
                    </div>
                    <div class="lynessa-products style-04">
                        <div class="response-product product-list-owl owl-slick equal-container better-height"
                             data-slick="{&quot;arrows&quot;:true,&quot;slidesMargin&quot;:30,&quot;dots&quot;:true,&quot;infinite&quot;:false,&quot;speed&quot;:300,&quot;slidesToShow&quot;:4,&quot;rows&quot;:1}"
                             data-responsive="[{&quot;breakpoint&quot;:480,&quot;settings&quot;:{&quot;slidesToShow&quot;:2,&quot;slidesMargin&quot;:&quot;10&quot;}},{&quot;breakpoint&quot;:768,&quot;settings&quot;:{&quot;slidesToShow&quot;:2,&quot;slidesMargin&quot;:&quot;10&quot;}},{&quot;breakpoint&quot;:992,&quot;settings&quot;:{&quot;slidesToShow&quot;:3,&quot;slidesMargin&quot;:&quot;20&quot;}},{&quot;breakpoint&quot;:1200,&quot;settings&quot;:{&quot;slidesToShow&quot;:3,&quot;slidesMargin&quot;:&quot;20&quot;}},{&quot;breakpoint&quot;:1500,&quot;settings&quot;:{&quot;slidesToShow&quot;:4,&quot;slidesMargin&quot;:&quot;30&quot;}}]">
                                 <?php
                                 foreach ($products as $key => $product) {
                                     $sub_r_products = Product::getSubProductsByParent($product['id']);
                                     if (count($sub_r_products) > 0) {
                                         $min_price = Product::getMinimumPrice($product['id']);
                                         $discount = ($min_price['price'] * $min_price['discount']) / 100;
                                         $price = $min_price['price'] - $discount;
                                         $old_price = $min_price['price'];
                                     } else {
                                         $discount = ($product['price'] * $product['discount']) / 100;
                                         $price = $product['price'] - $discount;
                                         $old_price = $product['price'];
                                     }

                                     if ($key > 5) {
                                         break;
                                     }
                                     ?>
                                <div class="product-item recent-product style-04 rows-space-0 post-93 product type-product status-publish has-post-thumbnail product_cat-light product_cat-table product_cat-new-arrivals product_tag-table product_tag-sock first instock shipping-taxable purchasable product-type-simple  ">
                                    <div class="product-inner tooltip-top tooltip-all-top">
                                        <div class="product-thumb">
                                            <a class="thumb-link"
                                               href="view-product.php?id=<?php echo $product['id']; ?>" tabindex="0">
                                                <img class="img-responsive"
                                                     src="upload/product-categories/sub-category/product/photos/<?php echo $product['image_name']; ?>"
                                                     alt="KNIT LIKE" width="270" height="350">
                                            </a>
                                            <div class="flash">
                                                <span class="onnew"><span class="text">New</span></span></div>
                                            <div class="group-button">

                                                <a href="view-product.php?id=<?php echo $product['id']; ?>" class="button yith-wcqv-button">Quick View</a>


                                            </div>
                                        </div>
                                        <div class="product-info">
                                            <h3 class="product-name product_title">
                                                <a href="view-product.php?id=<?php echo $product['id']; ?>"
                                                   tabindex="0"><?php
                                                       if (strlen($product['name']) > 30) {
                                                           echo substr($product['name'], 0, 28) . '...';
                                                       } else {
                                                           echo $product['name'];
                                                       }
                                                       ?>
                                                </a>
                                            </h3>
                                            <span class="price">
                                                <?php
                                                if ($discount == 0) {
                                                    ?>
                                                    <span class="price"> Rs. <?php echo number_format($price, 2); ?></span>
                                                    <?php
                                                } else {
                                                    ?>
                                                    <span class="price"> Rs. <?php echo number_format($price, 2); ?></span> <del><span class="price-before-discount">Rs. <?php echo number_format($old_price, 2); ?></span> </del>
                                                    <?php
                                                }
                                                ?>
                                            </span>
                                            <!--<div class="rating-wapper nostar">
                                                <div class="star-rating"><span style="width:0%">Rated <strong
                                                        class="rating">0</strong> out of 5</span></div>
                                                <span class="review">(0)</span>
                                            </div>-->

                                        </div>
                                    </div>
                                </div>

                                <?php
                            }
                            ?> 
                        </div>
                    </div>
                </div>
            </div>
            <?php
            foreach (Offer::all() as $key => $offer) {
                if ($key < 1) {
                    ?>
                    <div class="section-038">
                        <div class="lynessa-banner style-07 left-center">
                            <div class="banner-inner">
                                <figure class="banner-thumb">
                                    <img src="upload/offer/<?php echo $offer['image_name']; ?>"
                                         class="attachment-full size-full" alt="img"></figure>
                                <div class="banner-info container">
                                    <div class="banner-content">
                                        <div class="title-wrap">
                                            <div class="banner-label">
                                                <?php
                                                $date = date_create($offer['date']);
                                                echo date_format($date, 'd - M - Y');
                                                ?>
                                            </div>
                                            <h6 class="title">
                                                Online Offer</h6>
                                        </div>
                                        <div class="cate">
                                            <?php echo $offer['discount']; ?>% Off / Selected items
                                        </div>
                                        <div class="button-wrap">
                                            <div class="subtitle">
                                                <?php echo $offer['short_description']; ?>
                                            </div>
                                            <a class="button" target="_self" href="designs.php"><span>Shop now</span></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                }
                ?>
                <?php
            }
            ?>
            <div class="section-033">
                <div class="container">
                    <div class="section-034">
                        <div class="row">
                            <div class="col-xs-12 col-sm-10 col-md-6 offset-sm-1 col-xl-5 col-lg-5">
                                <div class="lynessa-slide">
                                    <div class="owl-slick equal-container better-height slider-l"
                                         data-slick="{&quot;arrows&quot;:false,&quot;slidesMargin&quot;:0,&quot;dots&quot;:true,&quot;infinite&quot;:false,&quot;speed&quot;:300,&quot;slidesToShow&quot;:1,&quot;rows&quot;:1}"
                                         data-responsive="[{&quot;breakpoint&quot;:480,&quot;settings&quot;:{&quot;slidesToShow&quot;:1,&quot;slidesMargin&quot;:&quot;0&quot;}},{&quot;breakpoint&quot;:768,&quot;settings&quot;:{&quot;slidesToShow&quot;:1,&quot;slidesMargin&quot;:&quot;0&quot;}},{&quot;breakpoint&quot;:992,&quot;settings&quot;:{&quot;slidesToShow&quot;:1,&quot;slidesMargin&quot;:&quot;0&quot;}},{&quot;breakpoint&quot;:1200,&quot;settings&quot;:{&quot;slidesToShow&quot;:1,&quot;slidesMargin&quot;:&quot;0&quot;}},{&quot;breakpoint&quot;:1500,&quot;settings&quot;:{&quot;slidesToShow&quot;:1,&quot;slidesMargin&quot;:&quot;0&quot;}}]">
                                             <?php
                                             foreach (Comments::all() as $comment) {
                                                 ?>
                                            <div class="lynessa-testimonial style-02">
                                                <div class="testimonial-inner">
                                                    <div class="desc">
                                                        <p><?php echo $comment['comment']; ?></p>
                                                    </div>
                                                    <div class="testimonial-info">
                                                        <div class="intro">
                                                            <h3 class="name">
                                                                <a href="#" target="_self" tabindex="0">
                                                                    <?php echo $comment['name']; ?> </a>
                                                            </h3>
                                                            <div class="position">
                                                                Customer
                                                            </div>
                                                        </div>
                                                        <div class="thumb">
                                                            <img src="upload/comments/<?php echo $comment['image_name']; ?>"
                                                                 class="attachment-full size-full" alt="img" width="97"
                                                                 height="97"></div>
                                                    </div>
                                                </div>
                                            </div>
                                            <?php
                                        }
                                        ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <br>
            <div class="border-top-1"></div>

        </div>
    </div>

    <!-- Start Header -->
    <?php include './footer.php'; ?>
    <!-- End Header -->



    <a href="#" class="backtotop active">
        <i class="fa fa-angle-up"></i>
    </a>
    <script src="assets/js/jquery-1.12.4.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/chosen.min.js"></script>
    <script src="assets/js/countdown.min.js"></script>
    <script src="assets/js/jquery.scrollbar.min.js"></script>
    <script src="assets/js/lightbox.min.js"></script>
    <script src="assets/js/magnific-popup.min.js"></script>
    <script src="assets/js/slick.js"></script>
    <script src="assets/js/jquery.zoom.min.js"></script>
    <script src="assets/js/threesixty.min.js"></script>
    <script src="assets/js/jquery-ui.min.js"></script>
    <script src="assets/js/mobilemenu.js"></script>
    <script src="assets/js/functions.js"></script>
    <script src="js/add-to-cart.js"></script>
</body>

</html>