<?php
include './db.php';
include './function.php';
$welcome = getWelcomeNote()
?>
<!DOCTYPE html>

<html>
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />

        <title>Madol Duwa Boat Ride</title>        

        <meta name="description" content="Welcome to Gin River Safari , If you stay at the Galle, Hikkaduwa, Unawatuna area you should go with a boat at the Gin Ganga. Usually we start the safari in gintota bridge. Also, we do not use motor boat and the boat is ridden by two people and your tour make it so nature friendly. So you will able to hear many bird sounds and water flow sounds of the river. We run the business as our family and we will make you happy for your value." />
        <meta name="keywords" content="Gin River Safari,gin ganga,madu ganga river safari,Gin ganga boat safari,Gin ganga tour,Gin ganga trip,Gin ganga mangroves,Gin ganga biodiversity" />

        <link rel="icon" type="image/png" sizes="32x32" href="images/about/icon.png">
        <!-- Bootstrap -->
        <link href="css/bootstrap.css" rel="stylesheet">
        <!-- font-awesome -->
        <link href="css/font-awesome.css" rel="stylesheet">
        <!-- chosen.min -->
        <link href="css/chosen.min.css" rel="stylesheet">
        <!-- slick-slider -->
        <link href="css/slick-slider.css" rel="stylesheet">
        <!-- jquery.bxslider -->
        <link href="css/jquery.bxslider.css" rel="stylesheet">
        <!-- prettyPhoto -->
        <link href="css/prettyPhoto.css" rel="stylesheet">
        <!-- responsive menu component -->
        <link href="js/responsive-menu/component.css" rel="stylesheet">
        <!-- svg-icons -->
        <link href="css/svg-icons.css" rel="stylesheet">
        <!-- Typography -->
        <link href="css/typography.css" rel="stylesheet">
        <!-- jquery.auto-complete -->
        <link href="css/jquery.auto-complete.css" rel="stylesheet">
        <!-- shortcodes -->
        <link href="css/shortcodes.css" rel="stylesheet">
        <!-- Colors -->
        <link href="css/colors.css" rel="stylesheet">
        <!-- Style Sheet -->
        <link href="style.css" rel="stylesheet">
        <!-- Responsive theme-->
        <link href="css/responsive.css" rel="stylesheet">
        <link href="css/mystyle.css" rel="stylesheet">


    </head>
    <body>
        <div class="eco_wrapper"> 
            <?php
            include './header.php';
            include './slider.php';
            ?>



            <div class="content">

                <!--Eco Template section-->
                <section class="eco_services_environment">
                    <!--Eco Template section content-->
                    <div class="container">
                        <!--Eco Template Heading-->
                        <div class="eco_headings" >
                            <h3><?php echo $welcome['title']; ?></h3> 
                            <span><i class="icon-nature-2"></i></span>
                        </div>
                        <!--Eco services-->
                        <div class="eco_services">
                            <div class="row">
                                <p style="text-align: center"><?php echo $welcome['description']; ?></p>
                            </div>
                            <div class="row">
                                <div style="display: table; width: 140px; margin: 10px auto 0 auto">
                                    <a href="about-us.php" class="btn btn-success center-block" >Read More</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--Eco Template section content ends-->
                </section>
                <!--Eco Template section ends-->

                <!--Eco Template section-->
                <section>
                    <!--Eco Template section content-->
                    <div class="container">
                        <!--Eco Template Heading-->
                        <div class="eco_headings">
                            <h3> Excursion </h3>
                            <span><i class="icon-nature-2"></i></span>
                        </div>
                        <!--Eco services-->
                        <div class="eco_featured_causes">
                            <div class="row">
                                <!--Eco services flip colums-->
                                <?php
                                $activities = getAllActivities();

                                if (count($activities) > 0) {
                                    foreach ($activities as $key => $activitie) {
                                        if ($key == 3) {
                                            break;
                                        }
                                        ?>
                                        <div class="col-md-4 col-sm-6 responsive-devider-50">
                                            <div class="eco_flip-container">
                                                <div class="flipper feature-blog">
                                                    <div class="front">
                                                        <figure>
                                                            <div class="eco-thumb">
                                                                <img src="images/excursion/<?php echo $activitie["image_name"]; ?>" alt="">
                                                            </div>
                                                        </figure>
                                                        <div class="feature_blog_caption">
                                                            <h5><a href="#"><?php echo $activitie["title"]; ?></a></h5>
                                                            <p class="text-justify"><?php echo substr($activitie["sort_description"], 0, 165) . " ..."; ?></p>

                                                            <span class="eco_progress-heading skill">Read More</span>


                                                        </div>
                                                    </div>
                                                    <div class="back eco-thumb-bg">	
                                                        <div class="feature_blog_caption">
                                                            <h3><?php echo $activitie["title"]; ?></h3>

                                                            <p><?php echo substr($activitie["sort_description"], 0, 300) . " ..."; ?></p>


                                                            <a href="view-excursion.php?id=<?php echo $activitie["id"]; ?>" class="lg-button">Read More</a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <?php
                                    }
                                } else {
                                    ?> 
                                    <b style="padding-left: 15px;">No excursion in the database.</b> 
                                <?php } ?> 

                                <!--Eco services flip colums ends-->
                            </div>
                        </div>
                        <!--Eco Template section content ends-->

                        <div class="row">
                            <div style="display: table; width: 140px; margin: 10px auto 0 auto; padding-top: 25px;">
                                <a href="excursion.php" class="btn btn-success center-block" >See All</a>
                            </div>
                        </div>
                </section>
                <!--Eco Template section ends-->


                <!--Eco section start-->
                <div class="eco-testimonial-section" style="background-image: url(images/bg/comment.jpg)">


                    <!--Eco testimonial content-->
                    <div class="container">
                        <!--Eco Template Heading-->
                        <div class="eco_headings white-color">
                            <h3>Testimonial</h3>

                            <span><i class="icon-nature-2"></i></span>
                        </div>
                        <!--Eco testimonial section-->
                        <div class="eco_testimonial-section">
                            <!--Eco testimonial slider-->
                            <div class="slider-nav">

                                <?php
                                $gestcomments = getAllComments();

                                if (count($gestcomments) > 0) {
                                    foreach ($gestcomments as $key => $comment) {
                                        if ($key == 10) {
                                            break;
                                        }
                                        ?>
                                        <!--Eco testimonial slider column-->
                                        <div class="eco_testimonial-user">
                                            <div class="img-slide">
                                                <img src="images/comments/<?php echo $comment["image_name"]; ?>" alt="">
                                            </div>
                                            <ul class="eco_testimonial_meta">
                                                <li>
                                                    <a href="#"><?php echo $comment["name"]; ?></a>

                                                </li>
                                            </ul>
                                        </div>
                                        <!--Eco testimonial slider column-->
                                        <?php
                                    }
                                } else {
                                    ?> 
                                    <b>No comments in the database.</b> 
                                <?php } ?> 


                            </div>
                            <!--Eco testimonial slider ends-->

                            <!--Eco testimonial slider column show data-->
                            <div class="slider-for">

                                <?php
                                $gestcomments = getAllComments();

                                if (count($gestcomments) > 0) {
                                    foreach ($gestcomments as $comment) {
                                        ?>
                                        <div class="testimonial-information">
                                            <p><?php echo substr($comment["comment"], 0, 200); ?></p>
                                        </div> 
                                        <?php
                                    }
                                } else {
                                    ?> 
                                    <b>No comments in the database.</b> 
                                <?php } ?> 
                            </div>
                            <!--Eco testimonial slider column show data ends-->
                        </div>
                        <!--Eco testimonial section ends-->

                        <div class="row">
                            <div style="display: table; width: 140px; margin: 10px auto 0 auto; padding-top: 25px;">
                                <a href="comment.php" class="btn btn-success center-block" >Add Comments</a>
                            </div>
                        </div>
                    </div>
                    <!--Eco testimonial ends-->
                </div>
                <!--Eco section ends-->

                <!--Eco section start-->
                <section>
                    <!--Eco blog content-->
                    <div class="container">
                        <!--Eco Template Heading-->
                        <div class="eco_headings">
                            <h3>Album</h3> 
                            <span><i class="icon-nature-2"></i></span>
                        </div>
                        <!--Eco blog-->
                        <div class="eco_blog_section">
                            <div class="row">
                                <?php
                                $albums = getAllAlbum();

                                if (count($albums) > 0) {
                                    foreach ($albums as $key => $album) {
                                        if ($key == 0) {
                                            ?>
                                            <!--Eco blog column-->
                                            <div class="col-md-4 col-sm-6 responsive-col-xs">
                                                <!--Eco blog column-->
                                                <div class="eco_blog_column">
                                                    <!--Eco blog column picture-->
                                                    <figure>
                                                        <div class="eco_thumb eco_hover_effect">
                                                            <img src="images/album/thumb/<?php echo $album["image_name"]; ?>" alt="">	
                                                            <div class="eco_hover_btn">
                                                                <a class="mediem_btn_02" href="view-album.php?id=<?php echo $album["id"]; ?>">View Album</a>
                                                            </div>
                                                        </div>
                                                    </figure>
                                                    <!--Eco blog column content-->
                                                    <div class="eco_blog_content"> 
                                                        <!--Eco blog date-->

                                                        <div class="eco-event-title">
                                                            <h5><?php echo $album["title"]; ?></h5>
                                                        </div>
                                                        <ul class="eco_viewers_meta">
                                                            <li><a href="#"><?php
                                                                    $count = countPhotos($album["id"]);
                                                                    echo $count;
                                                                    ?> Photos</a></li> 
                                                        </ul>
                                                        <p class="text-justify"><?php echo substr($album["shortDescription"], 0, 130) . " ..."; ?></p>
                                                    </div>
                                                </div>
                                            </div>
                                            <!--Eco blog column-->
                                            <?php
                                        }
                                    }
                                } else {
                                    ?> 
                                    <b style="padding-left: 15px;">No Album in the database.</b> 
                                <?php } ?> 



                                <?php
                                $albums = getAllAlbum();

                                if (count($albums) > 0) {
                                    foreach ($albums as $key => $album) {
                                        if ($key == 1) {
                                            ?>

                                            <div class="col-md-4 col-sm-6 responsive-col-xs">
                                                <div class="eco_blog_column blog-picture-down">


                                                    <!--Eco blog column content-->
                                                    <div class="eco_blog_content"> 
                                                        <!--Eco blog date-->

                                                        <div class="eco-event-title">
                                                            <h5><?php echo $album["title"]; ?></h5>
                                                        </div>
                                                        <ul class="eco_viewers_meta">
                                                            <li><a href="#"><?php
                                                                    $count = countPhotos($album["id"]);
                                                                    echo $count;
                                                                    ?> Photos</a></li> 
                                                        </ul>
                                                        <p class="text-justify"><?php echo substr($album["shortDescription"], 0, 130) . " ..."; ?></p>
                                                    </div>
                                                    <!--Eco blog column picture-->
                                                    <figure>
                                                        <div class="eco_thumb eco_hover_effect">
                                                            <img src="images/album/thumb/<?php echo $album["image_name"]; ?>" alt="">	
                                                            <div class="eco_hover_btn">
                                                                <a class="mediem_btn_02" href="view-album.php?id=<?php echo $album["id"]; ?>">View Album</a>
                                                            </div>
                                                        </div>
                                                    </figure>
                                                </div>
                                            </div>

                                            <?php
                                        }
                                    }
                                } else {
                                    ?> 
                                    <b style="padding-left: 15px;">No Album in the database.</b> 
                                <?php } ?> 




                                <?php
                                $albums = getAllAlbum();

                                if (count($albums) > 0) {
                                    foreach ($albums as $key => $album) {
                                        if ($key == 2) {
                                            ?>
                                            <!--Eco blog column-->
                                            <div class="col-md-4 col-sm-6 responsive-col-xs">
                                                <!--Eco blog column-->
                                                <div class="eco_blog_column">
                                                    <!--Eco blog column picture-->
                                                    <figure>
                                                        <div class="eco_thumb eco_hover_effect">
                                                            <img src="images/album/thumb/<?php echo $album["image_name"]; ?>" alt="">	
                                                            <div class="eco_hover_btn">
                                                                <a class="mediem_btn_02" href="view-album.php?id=<?php echo $album["id"]; ?>">View Album</a>
                                                            </div>
                                                        </div>
                                                    </figure>
                                                    <!--Eco blog column content-->
                                                    <div class="eco_blog_content"> 
                                                        <!--Eco blog date-->

                                                        <div class="eco-event-title">
                                                            <h5><?php echo $album["title"]; ?></h5>
                                                        </div>
                                                        <ul class="eco_viewers_meta">
                                                            <li><a href="#"><?php
                                                                    $count = countPhotos($album["id"]);
                                                                    echo $count;
                                                                    ?> Photos</a></li> 
                                                        </ul>
                                                        <p class="text-justify"><?php echo substr($album["shortDescription"], 0, 130) . " ..."; ?></p>
                                                    </div>
                                                </div>
                                            </div>
                                            <!--Eco blog column-->
                                            <?php
                                        }
                                    }
                                } else {
                                    ?> 
                                    <b style="padding-left: 15px;">No Album in the database.</b> 
                                <?php } ?> 
                            </div>
                        </div>

                        <div class="row">
                            <div style="display: table; width: 140px; margin: 10px auto 0 auto; padding-top: 25px;">
                                <a href="gallery.php" class="btn btn-success center-block" >See All</a>
                            </div>
                        </div>
                        <!--Eco blog ends-->
                    </div>
                    <!--Eco blog ends-->
                </section>
                <!--Eco section ends-->


            </div>



            <?php
            include './footer.php';
            ?>

        </div>
        <div id="preloader">
            <div id="status"></div>
        </div>

        <!-- jQuery (JavaScript plugins) -->
        <script src="js/jquery.js"></script>
        <script src="js/jquery.dlmenu.js" type="text/javascript"></script>
        <script src="js/modernizr.custom.js" type="text/javascript"></script>
        <script src="js/responsive-menu/jquery.dlmenu.js"></script>
        <!-- Bootstrap js -->
        <script src="js/bootstrap-lab.js"></script>
        <script src="js/bootstrap.js"></script>
        <!--responsive-menu -->
        <script src="js/responsive-menu/modernizr.custom.js"></script>

        <!-- masonry & filterable -->
        <script src="js/jquery-filterable.js"></script>
        <script src="js/masonry-gallery.js"></script>
        <!-- chosen.jquery js -->
        <script src="js/chosen.jquery.min.js"></script>
        <script src="js/jquery.auto-complete.js"></script>
        <!-- jquery.prettyPhoto js -->
        <script src="js/jquery.prettyPhoto.js"></script>
        <!-- countup and countdown js -->
        <script src="js/countup.js"></script>
        <script src="js/jquery.countdown.js"></script>
        <!-- slider -->
        <script src="js/slick-slider.js"></script>
        <script src="js/jquery.bxslider.js"></script>
        <script src="js/owl.carousel.js"></script>
        <!-- custom js -->
        <script src="js/custom.js"></script>

    </body>
</html>
