<?php
include_once(dirname(__FILE__) . '/class/include.php');

$EVENT = new Events(Null);
//$NEWS = new News(Null);
$ALBUM_PHOTO = new AlbumPhoto(Null);
$PORTFOLIO = new Portfolio(Null);
$COMMENT = new Comments(Null);
?>
<!DOCTYPE html>
<html>

    <head>
        <meta charset="utf-8">
        <title>Women's Development Federation | Home</title>
        <!-- Stylesheets -->
        <link href="images/icons/favicon.png" rel="icon" sizes="32x32" type="image/png">
        <link href="css/bootstrap.css" rel="stylesheet">
        <link href="css/revolution-slider.css" rel="stylesheet">
        <link href="css/style.css" rel="stylesheet">
        <!-- Responsive -->
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">
        <link href="css/responsive.css" rel="stylesheet">
        <!--[if lt IE 9]><script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script><![endif]-->
        <!--[if lt IE 9]><script src="js/respond.js"></script><![endif]-->
        <link href="fancybox-master/css/jquery.fancybox.min.css" rel="stylesheet" type="text/css"/>
    </head>

    <body>
        <div class="page-wrapper">

            <!-- Header Style Two-->
            <?php
            include 'header.php';
            ?>
            <!--End Header Style Two-->

            <!--Main Slider-->
            <?php
            include 'slider.php';
            ?>
            <!--End Main Slider-->

            <!--Events Section-->
            <section class="welcome-section bg-color-fc sec-padding56">
                <div class="auto-container">

                    <div class="row clearfix">

                        <!--Become Volunteer-->
                        <div class="column default-featured-column style-three col-lg-4 col-md-4 col-sm-6 col-xs-12">
                            <h4 class="inner-title double-line line-left">Became a Volunteer</h4>
                            <article class="inner-box">
                                <figure class="image-box">
                                    <a href="#"><img src="images/resource/team-image-b1.png" alt=""></a>
                                    <div class="post-tag">Volunteer</div>
                                </figure>
                                <div class="content-box">
                                    <h3><a href="#">Meet Our Volunteers</a></h3>
                                    <div class="column-info">Join Our Volunteer & Helping Us</div>
                                    <div class="text">Volunteering gives you a great feeling because you know you're making a difference..</div>
                                    <a href="become-volunteer.php" class="theme-btn btn-style-two btn-sm">Join With Us</a>
                                    <a href="#" class="theme-btn btn-style-four btn-sm">Who We Need</a>
                                    <!--<a href="#" class="theme-btn btn-style-four btn-sm">Volunteer</a>-->
                                </div>
                            </article>
                        </div>

                        <!--Featured Column-->
                        <div class="column default-featured-column style-three col-lg-4 col-md-4 col-sm-6 col-xs-12">
                            <h4 class="inner-title double-line line-left">Latest Project</h4>
                            <div class="featured-project owl-carousel owl-nav-style owl-nav3"> 
                                <?php
                                foreach ($PORTFOLIO->all() as $portfolio) {
                                    ?>
                                    <article class="inner-box">
                                        <figure class="image-box">
                                            <a href="view-project.php?id=<?php echo $portfolio["id"];?>"><img src="upload/portfolio/<?php echo $portfolio['image_name'] ?>" alt=""></a>
                                            <!--<div class="post-tag">Urgent Cause</div>-->
                                        </figure>
                                        <div class="content-box">
                                            <h3><a href="view-project.php?id=<?php echo $portfolio["id"];?>"><?php echo $portfolio['title'] ?></a></h3>
                                            <div class="column-info">Date: <?php echo $portfolio['date'] ?></div>
                                            <div class="text"><?php echo substr($portfolio['short_description'], 0, 120) . '...'; ?></div>
                                            <a href="view-project.php?id=<?php echo $portfolio["id"];?>" class="theme-btn btn-style-two btn-sm">Read More</a>
                                            <a href="become-volunteer.php" class="theme-btn btn-style-four btn-sm">Join Now</a>
                                        </div>
                                    </article>
                                    <?php
                                }
                                ?>
                            </div>
                        </div>

                        <!--Cause Column-->
                        <div class="column default-featured-column links-column col-lg-4 col-md-4 col-sm-6 col-xs-12">
                            <article class="inner-box">
                                <h4 class="inner-title double-line line-left">Latest News</h4>
                                <div class="vertical-links-outer events-post">
                                    <div class="events-post-dv text-uppercase bg-black-grey">
                                        <h2 class="white_color fw-b fs-24">Join <span class="theme_color">our news</span> &amp; helping us by donation</h2>
                                    </div>

                                    <div class="bx-event-carousel-style2">
                                        <?php
                                        foreach ($EVENT->all() as $event) {
                                            ?>
                                            <div class="link-block">
                                                <div class="default inner">
                                                    <figure class="image-thumb"><img src="upload/event/<?php echo $event['image_name']; ?>" alt=""></figure>
                                                    <h4 class="title"><?php echo substr($event['title'], 0, 15) . '...'; ?></h4>
                                                    <ul class="event-held">
                                                        <li><i class="fa fa-calendar-o"></i> <?php echo $event['date']; ?></li>
                                                        <li> <i class="fa fa-map-marker"></i> <?php echo $event['venue']; ?></li>
                                                    </ul>
                                                    <ul class="event-date">
                                                        <li class="event-day">
                                                            <?php
                                                            $date = $event['date'];
                                                            $date = date('d', strtotime($date));
                                                            echo $date;
                                                            ?>
                                                        </li>
                                                        <li class="event-month">
                                                            <?php
                                                            $date = $event['date'];
                                                            $date = date('F', strtotime($date));
                                                            echo $date;
                                                            ?>
                                                        </li>
                                                    </ul>
                                                </div>
                                                <div class="alternate">
                                                    <p class="desc"><?php echo substr($event['short_description'], 0, 75) . '...'; ?></p>
                                                    <a class="theme-btn btn-style-five btn-xs" href="view-event.php?id=<?php echo $event["id"];?>">Read More</a>
                                                    <a class="theme-btn btn-style-two btn-xs" href="become-volunteer.php">Join Now</a>
                                                </div>
                                            </div>
                                            <?php
                                        }
                                        ?>
                                    </div>

                                </div>
                            </article>
                        </div>

                    </div>
                </div>
            </section>


            <!--Gallery Section-->
            <section id="gallery-home" class="gallery-section gutterless">
                <div class="container">       
                    <div class="sec-title text-center">
                        <h2>Our <span class="normal-font theme_color">Gallery</span></h2>
                    </div>
                </div>

                <div class="container-fluid">

                    <!--Filter List-->
                    <div class="row filter-list clearfix hidden-xs hidden-sm">
                        <!--Column-->
                        <?php 
                        foreach ($ALBUM_PHOTO->all() as $key => $album_photo) {
                            if ($key < 8) {
                                ?>
                                <div class="column mix mix_all eco plants col-md-3 col-sm-6 col-xs-12">
                                    <!--Default Portfolio Item-->
                                    <div class="default-portfolio-item">
                                        <div class="inner-box text-center">
                                            <!--Image Box-->
                                            <figure class="image-box"><img src="upload/photo-album/gallery/thumb/<?php echo $album_photo['image_name'] ?>" alt=""></figure>
                                            <div class="overlay-box">
                                                <div class="inner-content">
                                                    <div class="content">
                                                        <a class="arrow lightbox-image" href="upload/photo-album/gallery/<?php echo $album_photo['image_name'] ?>" data-fancybox="images"><span class="icon flaticon-cross-4"></span></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php
                            }
                        }
                        ?>
                    </div>
                    <div class="row filter-list clearfix hidden-lg hidden-md">
                        <div id="gallery-carousel" class="owl-carousel owl-theme">
                            <!--Column-->
                            <?php
                            foreach ($ALBUM_PHOTO->all() as $key => $album_photo) {
                                if ($key < 8) {
                                    ?>
                                    <div class="column mix mix_all eco plants col-md-3 col-sm-6 col-xs-12">
                                        <!--Default Portfolio Item-->
                                        <div class="default-portfolio-item">
                                            <div class="inner-box text-center">
                                                <!--Image Box-->
                                                <figure class="image-box"><img src="upload/photo-album/gallery/thumb/<?php echo $album_photo['image_name'] ?>" alt=""></figure>
                                                <div class="overlay-box">
                                                    <div class="inner-content">
                                                        <div class="content">
                                                            <a class="arrow lightbox-image" href="upload/photo-album/gallery/<?php echo $album_photo['image_name'] ?>" data-fancybox="images"><span class="icon flaticon-cross-4"></span></a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php
                                }
                            }
                            ?>
                        </div>
                    </div>

                </div>
            </section>

            <!--Intro Section-->
            <section class="subscribe-intro">
                <div class="auto-container">
                    <div class="row clearfix">
                        <!--Column-->
                        <div class="column col-md-9 col-sm-12 col-xs-12">
                            <h2>Do you want to join with us</h2>
                            Now you can join with us as a volunteer.... 
                        </div>
                        <!--Column-->
                        <div class="column col-md-3 col-sm-12 col-xs-12">
                            <div class="text-right padd-top-20">
                                <a href="become-volunteer.php" class="theme-btn btn-style-one">Join Now</a>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <!--Recent Causes Section-->
            <section class="recent-projects">
                <div class="auto-container">

                    <div class="sec-title clearfix">
                        <div class="pull-left">
                            <h2>Our <span class="normal-font theme_color">Projects</span></h2>
                            <div class="text">Find out more about our projects in the local communities.</div>
                        </div>
                        <div class="pull-right padd-top-30">
                            <a href="projects.php" class="theme-btn btn-style-three">See All Projects</a>
                        </div>
                    </div>
                    <div class="row clearfix">

                        <!--Default Featured Column-->
                        <?php
                        foreach ($PORTFOLIO->all() as $key => $portfolio) {
                            if ($key < 3) {
                                ?>
                                <div class="column default-featured-column style-two col-lg-4 col-md-4 col-sm-6 col-xs-12">
                                    <article class="inner-box wow fadeInLeft" data-wow-delay="900ms" data-wow-duration="1500ms">
                                        <figure class="image-box">
                                            <a href="view-project.php?id=<?php echo $portfolio["id"];?>"><img src="upload/portfolio/<?php echo $portfolio['image_name'] ?>" alt=""></a>
        <!--                                            <div class="post-tag"><?php // echo $portfolio['date']  ?></div>-->
                                        </figure>
                                        <div class="content-box">
                                            <h3><a href="view-project.php?id=<?php echo $portfolio["id"];?>"><?php echo $portfolio['title'] ?></a></h3>
                                            <div class="text"><?php echo substr($portfolio['short_description'], 0, 120) . '...'; ?></div>
                                            <a href="view-project.php?id=<?php echo $portfolio["id"];?>" class="theme-btn btn-style-two btn-sm">Read More</a>
                                            <a href="become-volunteer.php" class="theme-btn btn-style-four btn-sm">Join With Us</a>
                                        </div>
                                    </article>
                                </div>
                                <?php
                            }
                        }
                        ?>
                        <!--Default Featured Column-->
                        <!--                        <div class="column default-featured-column style-two col-lg-3 col-md-6 col-sm-6 col-xs-12">
                                                    <article class="inner-box wow fadeInLeft" data-wow-delay="900ms" data-wow-duration="1500ms">
                                                        <figure class="image-box">
                                                            <a href="#"><img src="images/causes/2.jpg" alt=""></a>
                                                            <div class="donate-piechart">
                                                                <div class="piechart-block">
                                                                    <div class="piechart style-one"  data-fg-color="rgba(250,119,68,1)" data-value=".65">
                                                                        <span>.65</span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </figure>
                                                        <div class="content-box">
                                                            <h3><a href="#">Charity For Education</a></h3>
                                                            <div class="column-info"><span class="raised-amount">Raised: $2570</span> Goal: $3500</div>
                                                            <div class="text">Lorem ipsum dolor sit amet et siu amet amet audiam copiosaei mei.</div>
                                                            <a href="#" class="theme-btn btn-style-four btn-sm">Donate Now</a>
                                                            <a href="#" class="theme-btn btn-style-two btn-sm">Read More</a>
                                                        </div>
                                                    </article>
                                                </div>-->


                    </div>
                </div>
            </section>

            <!--Testimonials-->
            <section class="testimonials-section bg-color-f5">
                <div class="auto-container">

                    <div class="sec-title text-center">
                        <h2 class="black_color">Testi<span class="normal-font theme_color">Monials</span></h2>
                        <div class="text black_color">Our volunteer reviews</div>
                    </div>

                    <!--Slider-->      
                    <div class="testimonials-slider testimonials-carousel">
                        <?php
                        foreach ($COMMENT->all() as $comments) {
                            ?>
                            <!--Slide-->
                            <article class="slide-item">

                                <div class="info-box">
                                    <figure class="image-box"><img src="upload/comments/<?php echo $comments["image_name"]; ?>" alt=""></figure>
<!--                                    <figure class="image-box"><img src="https://docs.osclasspoint.com/wp-content/plugins/all-in-one-seo-pack/images/default-user-image.png" alt=""></figure>-->
                                    <h3><?php echo $comments["name"]; ?></h3>
                                    <p class="designation"><?php echo $comments["title"]; ?></p>
                                </div>

                                <div class="slide-text">
                                    <p><?php echo $comments["comment"]; ?></p>
                                </div>
                            </article>

                            <?php
                        }
                        ?>
                    </div>

                </div>    
            </section> 

            <!--Main Features-->
            <section class="main-features parallax-section theme-overlay overlay-deep-white" style="background-image:url(images/parallax/image-1.jpg);">
                <div class="auto-container">
                    <div class="title-box text-center">
                        <h1 class="text-uppercase fs-36">Became A Part Of The World</h1>
                        <h2>Working With US by helping & donation</h2>
                        <div class="text">Volunteering can help you make friends, learn new skills, advance your career, and even feel happier and healthier.</div>
                        <div class=""> 
                            <a class="theme-btn btn-style-two" href="become-volunteer.php">Join With Us</a>
                        </div>
                    </div>
                </div>
            </section>

            <!--Main Footer-->
            <?php
            include 'footer.php';
            ?>
            <!--End Main Footer-->

        </div>
        <!--End pagewrapper-->


        <!--Scroll to top-->
        <div class="scroll-to-top scroll-to-target" data-target=".page-wrapper">
            <span class="fa fa-long-arrow-up">
            </span>
        </div>


        <!--Donate Popup-->
        <!--        <div class="modal fade pop-box" id="donate-popup" tabindex="-1" role="dialog" aria-labelledby="donate-popup" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            Donation Section
                            <section class="donation-section">
                                <div class="donation-form-outer">
                                    <form method="post" action="http://hasan.themexlab.com/new/charity-club-html/contact.html">
        
                                        Form Portlet
                                        <div class="form-portlet">
                                            <h3>How Much Would you like to Donate?</h3>
        
                                            <div class="row clearfix">
                                                <div class="form-group col-lg-7 col-md-12 col-xs-12 clearfix">
        
                                                    <div class="radio-select">
                                                        <input type="radio" name="sel-amount" id="amount-1">
                                                        <label for="amount-1">$10</label>
                                                    </div>
        
                                                    <div class="radio-select">
                                                        <input type="radio" name="sel-amount" id="amount-2" checked>
                                                        <label for="amount-2">$25</label>
                                                    </div>
        
                                                    <div class="radio-select">
                                                        <input type="radio" name="sel-amount" id="amount-3">
                                                        <label for="amount-3">$50</label>
                                                    </div>
        
                                                    <div class="radio-select">
                                                        <input type="radio" name="sel-amount" id="amount-4">
                                                        <label for="amount-4">$100</label>
                                                    </div>
        
                                                    <div class="radio-select">
                                                        <input type="radio" name="sel-amount" id="amount-5">
                                                        <label for="amount-5">$150</label>
                                                    </div>
        
                                                </div>
        
                                                <div class="form-group other-amount col-lg-5 col-md-8 col-xs-12 padd-top-10">
        
                                                    <input type="text" name="other-amount" value="" placeholder="Or Other Amount">
        
                                                </div>
        
                                            </div>
                                        </div>
        
                                        <br>
        
                                        Form Portlet
                                        <div class="form-portlet">
                                            <h4>Billing Information</h4>
        
                                            <div class="row clearfix">
        
                                                <div class="form-group col-lg-6 col-md-6 col-xs-12">
                                                    <div class="field-label">First Name <span class="required">*</span></div>
                                                    <input type="text" name="name" value="" placeholder="First Name" required>
                                                </div>
        
                                                <div class="form-group col-lg-6 col-md-6 col-xs-12">
                                                    <div class="field-label">Last Name <span class="required">*</span></div>
                                                    <input type="text" name="name" value="" placeholder="Last Name" required>
                                                </div>
        
                                                <div class="form-group col-lg-6 col-md-6 col-xs-12">
                                                    <div class="field-label">Email <span class="required">*</span></div>
                                                    <input type="email" name="name" value="" placeholder="Email" required>
                                                </div>
        
                                                <div class="form-group col-lg-6 col-md-6 col-xs-12">
                                                    <div class="field-label">Phone <span class="required">*</span></div>
                                                    <input type="text" name="name" value="" placeholder="Phone" required>
                                                </div>
        
                                                <div class="form-group col-lg-6 col-md-6 col-xs-12">
                                                    <div class="field-label">Address 1 <span class="required">*</span></div>
                                                    <input type="text" name="name" value="" placeholder="Address 1" required>
                                                </div>
        
                                                <div class="form-group col-lg-6 col-md-6 col-xs-12">
                                                    <div class="field-label">Address 2 <span class="required">*</span></div>
                                                    <input type="text" name="name" value="" placeholder="Address 2" required>
                                                </div>
        
                                            </div>
                                        </div>
        
                                        <br>
        
                                        Form Portlet
                                        <div class="form-portlet">
                                            <h4>Payment Information</h4>
        
                                            <div class="payment-option-logo"><img class="img-responsive" src="images/resource/payment-logos.png" alt=""></div>
                                            <br>
        
                                            <div class="row clearfix">
        
                                                <div class="form-group col-lg-6 col-md-6 col-xs-12">
                                                    <div class="field-label">Card Number <span class="required">*</span></div>
                                                    <input type="text" name="name" value="" placeholder="Card Number" required>
                                                </div>
        
                                                <div class="form-group col-lg-6 col-md-6 col-xs-12">
                                                    <div class="field-label">Card Holder Name <span class="required">*</span></div>
                                                    <input type="text" name="name" value="" placeholder="Card Holder Name" required>
                                                </div>
        
        
        
                                                <div class="form-group col-lg-3 col-md-3 col-xs-12">
                                                    <div class="field-label">Expire Date <span class="required">*</span></div>
                                                    <select>
                                                        <option>01</option>
                                                        <option>02</option>
                                                        <option>03</option>
                                                        <option>04</option>
                                                        <option>05</option>
                                                        <option>06</option>
                                                        <option>07</option>
                                                        <option>08</option>
                                                        <option>09</option>
                                                        <option>10</option>
                                                        <option>11</option>
                                                        <option>12</option>
                                                    </select>
                                                </div>
        
                                                <div class="form-group col-lg-3 col-md-3 col-xs-12">
                                                    <div class="field-label">&nbsp;</div>
                                                    <select>
                                                        <option>2016</option>
                                                        <option>2017</option>
                                                        <option>2018</option>
                                                        <option>2019</option>
                                                        <option>2020</option>
                                                    </select>
                                                </div>
        
                                                <div class="form-group col-lg-6 col-md-6 col-xs-12">
                                                    <div class="field-label">Security Code (CVC) <span class="required">*</span></div>
                                                    <input type="text" name="name" value="" placeholder="Security Code" required>
                                                </div>
        
                                            </div>
                                        </div>
        
                                        <div class="text-left"><button type="submit" class="theme-btn btn-style-two">Donate Now</button></div>
        
                                    </form>
                                </div>
                            </section>
                        </div>
                         /.modal-content 
                    </div>
                     /.modal-dialog 
                </div>-->
        <!-- /.modal -->

        <script src="js/jquery.js"></script> 
        <script src="js/bootstrap.min.js"></script>
        <script src="js/revolution.min.js"></script>
        <script src="js/jquery.bxslider.min.js"></script>
        <script src="js/owl.js"></script>
        <script src="js/mixitup.js"></script>
        <script src="js/wow.js"></script>
        <script src="js/circle-progress.js"></script>
        <script src="js/jquery.appear.js"></script>
        <script src="js/jquery.countTo.js"></script>
        <script src="fancybox-master/js/jquery.fancybox.min.js" type="text/javascript"></script>
        <script src="js/script.js"></script>

        <script type="text/javascript">
            $(document).ready(function () {
                $("#news-carousel").owlCarousel({
                    loop: true,
                    margin: 7,
                    nav: false,
                    autoplay: true,
                    autoplayTimeout: 2000,
                    autoplayHoverPause: true,
                    dots: false,
                    responsive: {
                        0: {
                            items: 1
                        },
                        600: {
                            items: 2
                        },
                        1000: {
                            items: 3
                        }
                    }
                });
            });
        </script>
        <script type="text/javascript">
            $(document).ready(function () {
                $("#gallery-carousel").owlCarousel({
                    loop: true,
                    margin: 7,
                    nav: false,
                    autoplay: true,
                    autoplayTimeout: 2000,
                    autoplayHoverPause: true,
                    dots: false,
                    responsive: {
                        0: {
                            items: 1
                        },
                        600: {
                            items: 2
                        },
                        1000: {
                            items: 3
                        }
                    }
                });
            });
        </script>
    </body>

</html>