<!DOCTYPE html>
<?php
include './class/include.php';
$SLIDER = new Slider(NULL);
$ROOM_OBJ = new Room(NULL);
$SERVICE_OBJ = new Service(NULL);
$COMMENT = new Comments(NULL);
$INDEX_ABOUT = new Page(1);
$INDEX_FACILITIES = new Page(2);
$INDEX_TRANSPORT = new Page(4);
?>
<html lang="en">
    <head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">

        <!-- TITLE -->
        <title>Chaaya Inn Hikkaduwa</title>

        <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
        <meta name="format-detection" content="telephone=no">
        <meta name="apple-mobile-web-app-capable" content="yes">
        <link rel="shortcut icon" href="images/favicon.png">

        <!-- GOOGLE FONT -->
        <link href='http://fonts.googleapis.com/css?family=Hind:400,300,500,600%7cMontserrat:400,700' rel='stylesheet' type='text/css'>
        <link href="https://fonts.googleapis.com/css?family=Hind:300,400,500,600,700" rel="stylesheet">

        <!-- CSS LIBRARY -->
        <link rel="stylesheet" type="text/css" href="css/lib/font-awesome.min.css">
        <link rel="stylesheet" type="text/css" href="css/lib/font-lotusicon.css">
        <link rel="stylesheet" type="text/css" href="css/lib/bootstrap.min.css">
        <link rel="stylesheet" type="text/css" href="css/lib/owl.carousel.css">
        <link rel="stylesheet" type="text/css" href="css/lib/jquery-ui.min.css">
        <link rel="stylesheet" type="text/css" href="css/lib/magnific-popup.css">
        <link rel="stylesheet" type="text/css" href="css/lib/settings.css">
        <link rel="stylesheet" type="text/css" href="css/lib/bootstrap-select.min.css">
        <link rel="stylesheet" type="text/css" href="css/helper.css">
        <link rel="stylesheet" type="text/css" href="css/custom.css">
        <link rel="stylesheet" type="text/css" href="css/responsive.css">
      

        <!-- MAIN STYLE -->
        <link rel="stylesheet" type="text/css" href="css/style.css">

    </head>

    <body> <!--<![endif]-->


        <!-- PRELOADER -->
        <div id="preloader">
            <span class="preloader-dot"></span>
        </div>
        <!-- END / PRELOADER -->

        <div id="page-wrap" class="bg-white-2">

            <!-- HEADER -->
            <?php include './header.php'; ?>
            <!-- END / HEADER -->


            <!-- BANNER SLIDER -->
            <?php include './slider.php'; ?>
            <!-- END / BANNER SLIDER -->  

            <!-- ABOUT -->
            <section class="section-home-about style-2 bg-white">
                <div class="container">
                    <div class="home-about">
                        <div class="row v-align">
                            <div class="col-xs-12 col-sm-6">
                                <div class="img-hover-box">
                                    <div class="img">
                                        <a href="#"><img class="img-responsive img-full" src="upload/page/<?php echo $INDEX_ABOUT->image_name; ?>" alt=""></a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xs-12 col-sm-6">
                                <div class="ot-heading row-20 text-center">
                                    <h2 class="mb30">ABOUT CHAAYA INN HOTEL</h2>
                                    <p class="mb30 font-hind f20 f600 pl30 pr30 lh27">
                                        A legendary welcome, every time
                                    </p>
                                </div>
                                <div class="text-center">
                                    <p class="f14">
                                        <?php echo $INDEX_ABOUT->description ?>
                                    </p>
                                    <a href="about.php" class="awe-btn awe-btn-default btn-medium font-hind bold f12 mt30">READ MORE</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- END / ABOUT -->

            <!-- OUR BEST -->
            <section class="section-our-best our-best-style-2 mt100 pt0 pb30 bg-white">
                <div class="container">
                    <div class="our-best">
                        <div class="row v-align">
                            <div class="col-xs-12 col-sm-6 col-sm-push-6">
                                <div class="img-hover-box">
                                    <div class="img mt0">
                                        <img class="img-responsive img-full" src="upload/page/<?php echo $INDEX_FACILITIES->image_name; ?>" alt="">
                                    </div>
                                </div>
                            </div>
                            <div class="col-xs-12 col-sm-6 col-sm-pull-6 ">
                                <div class="ot-heading row-20 text-center">
                                    <h2>Our Facilities</h2>

                                    <?php echo $INDEX_FACILITIES->description ?>

                                </div>
                                <div class="owl-single">
                                    <div class="row">
                                        <div class="col-xs-6 col-sm-4 col-md-4">
                                            <div class="item">
                                                <img class="img-responsive block mb10" src="images/index-icons/png/001-router.png" alt="icon">
                                                <span>Free Wifi</span>
                                            </div>
                                        </div>
                                        <div class="col-xs-6 col-sm-4 col-md-4">
                                            <div class="item">
                                                <img class="img-responsive block mb10" src="images/index-icons/png/003-parking.png" alt="icon">
                                                <span>Car Parking</span>
                                            </div>
                                        </div>
                                        <div class="col-xs-6 col-sm-4 col-md-4">
                                            <div class="item">
                                                <img class="img-responsive block mb10" src="images/index-icons/png/002-24-hours.png" alt="icon">
                                                <span>24 Hours Service</span>
                                            </div>
                                        </div>
                                        <div class="col-xs-6 col-sm-4 col-md-4">
                                            <div class="item">
                                                <img class="img-responsive block mb10" src="images/index-icons/png/004-dish.png" alt="icon">
                                                <span>Fresh Meals</span>
                                            </div>
                                        </div>
                                        <div class="col-xs-6 col-sm-4 col-md-4">
                                            <div class="item">
                                                <img class="img-responsive block mb10" src="images/index-icons/png/005-hotel.png" alt="icon">
                                                <span>Unique Room Features</span>
                                            </div>
                                        </div>
                                        
                                        <div class="col-xs-6 col-sm-4 col-md-4">
                                            <div class="item">
                                                <img class="img-responsive block mb10" src="images/index-icons/png/006-eco.png" alt="icon">
                                                <span>Eco Friendly</span>
                                            </div>
                                        </div>
                                    </div> 
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </section>
            <!-- END / OUR BEST -->

            <section class="section-accomd awe-parallax bg-14" style="background-position: 50% 133px;">
                <div class="container">
                    <div class="accomd-modations">
                        <div class="row">
                            <div class="col-md-12 mb30">
                                <div class="accomd-modations-header">
                                    <h2 class="heading">ROOMS &amp; RATES</h2>
                                    <img src="images/icon-accmod.png" alt="icon">

                                </div>
                            </div>
                            <div class="col-xs-12">
                                <div class="row">
                                    <?php
                                    $ROOM = $ROOM_OBJ->all();
                                    foreach ($ROOM as $key => $room) {
                                        if ($key < 3) {
                                            ?>
                                            <!-- ITEM -->
                                            <div class="col-md-4">
                                                <div class="accomd-modations-room">
                                                    <div class="img">
                                                        <a href="room-details.php?id=<?php echo $room['id'] ?>"><img src="upload/room/<?php echo $room['image_name'] ?>" alt=""></a>
                                                    </div>
                                                    <div class="text">
                                                        <h2><a href="room-details.php?id=<?php echo $room['id'] ?>"><?php echo $room['title'] ?></a></h2>

                                                    </div>
                                                </div>
                                            </div>
                                            <!-- END / ITEM -->

                                            <?php
                                        }
                                    }
                                    ?>
                                </div>
                                <div class="row">




                                    <?php
                                    foreach ($ROOM as $key => $room) {
                                        if ($key >= 3) {
                                            ?>
                                            <!-- ITEM -->
                                            <div class="col-md-6">
                                                <div class="accomd-modations-room">
                                                    <div class="img">
                                                        <a href="room-details.php?id=<?php echo $room['id'] ?>"><img src="upload/room/<?php echo $room['image_name'] ?>" alt=""></a>
                                                    </div>
                                                    <div class="text">
                                                        <h2><a href="room-details.php?id=<?php echo $room['id'] ?>"><?php echo $room['title'] ?></a></h2>

                                                    </div>
                                                </div>
                                            </div>
                                            <!-- END / ITEM -->

                                            <?php
                                        }
                                    }
                                    ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div> 
            </section>
            <section class="section-home-about bg-white">
                <div class="container">
                    <div class="home-about">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="img">
                                    <a href="#"><img src="images/about/3.png" alt=""></a>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="text">
                                    <h2 class="heading">Transport Service</h2>
                                    <span class="box-border"></span>
                                    <?php echo $INDEX_TRANSPORT ->description; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <section class = "section-deals mt90">
                <div class = "container">
                    <div class = "content">  
                        <div class = "accomd-modations-header">
                            <h2 class = "heading">Services</h2>
                            <img src = "images/icon-accmod.png" alt = "icon"> 
                        </div>

                        <div class = "row">
                            <?php
                            $SERVICE = $SERVICE_OBJ->all();
                            foreach ($SERVICE as $service) {
                                ?>
                                <div class = "col-xs-12 col-sm-6">
                                    <div class = "item item-deal">
                                        <div class = "img">
                                            <img class = "img-full" src = "upload/service/<?php echo $service['image_name'] ?>" alt = "">
                                        </div>
                                        <div class = "info">

                                            <p class = "sub font-monserat f12 f-600 upper mt10 mb20"><?php echo $service['title'] ?></p>
                                            <a class = "awe-btn awe-btn-12 btn-medium font-hind f12 bold" href="view-service.php?id=<?php echo $service['id'] ?>">Click here</a>
                                        </div>
                                    </div>
                                </div>
                                <?php
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </section>
            <div class = "section-home-guestbook parallax" style = "background-position: 50% 55px;">
                <div class = "container">
                    <div class = "home-guestbook">
                        <div class = "accomd-modations-header">
                            <h2 class = "heading" style = "color: #fff;">Guest Book</h2>
                            <img src = "images/icon-accmod.png" alt = "icon">

                        </div>
                        <div class = "row">
                            <div class = "col-md-12 col-lg-12">
                                <div class = "guestbook-content owl-single">
                                    <?php
                                    foreach ($COMMENT->activeComments() as $comment) {
                                        ?>
                                        <!--ITEM -->
                                        <div class = "guestbook-item">
                                            <div class = "img">
                                                <img src="upload/comments/<?php echo $comment['image_name']; ?>" alt="">
                                            </div>

                                            <div class = "text">
                                                <?php echo $comment['comment']; ?>

                                                <span><strong> <?php echo $comment['name']; ?></strong></span><br>
                                                <span>From  <?php echo $comment['country']; ?></span>
                                            </div>
                                        </div>
                                        <!--ITEM -->

                                        <?php
                                    }
                                    ?>

                                </div>
                            </div>
                        </div>

                    </div>
                </div>

            </div>
            <section class = "section-gallery bg-white hidden-xs">

                <div class = "gallery  no-padding">
                    <div class = "accomd-modations-header">
                        <h2 class = "heading">Gallery</h2>
                        <img src = "images/icon-accmod.png" alt = "icon">

                    </div>

                    <!--GALLERY CONTENT -->
                    <div class = "gallery-content hover-img">
                        <div class = "row">
                            <div class = "gallery-isotope col-6 pd-0" style = "position: relative; height: 314.438px;">

                                <!--ITEM SIZE -->
                                <div class = "item-size"></div>
                                <!--END / ITEM SIZE -->
                                <!--ITEM -->

                                <div class = "item-isotope suite dining " style = "position: absolute; left: 0%; top: 0px;">
                                    <div class = "gallery_item">
                                      
                                            <img src = "images/gallery/img-1.jpg" alt = "">
                                     
                                    </div>
                                </div>
                                <!--END / ITEM -->

                                <!--ITEM -->
                                <div class = "item-isotope  ground bathroom suite" style = "position: absolute; left: 16.655%; top: 0px;">
                                    <div class = "gallery_item">
                                      
                                            <img src = "images/gallery/img-2.jpg" alt = "">
                                       
                                    </div>
                                </div>
                                <!--END / ITEM -->

                                <!--ITEM -->
                                <div class = "item-isotope ground bathroom dining" style = "position: absolute; left: 33.3099%; top: 0px;">
                                    <div class = "gallery_item">
                                       
                                            <img src = "images/gallery/img-3.jpg" alt = "">
                                       
                                    </div>
                                </div>
                                <!--END / ITEM -->

                                <!--ITEM -->
                                <div class = "item-isotope suite dining" style = "position: absolute; left: 49.9649%; top: 0px;">
                                    <div class = "gallery_item">
                                       
                                            <img src = "images/gallery/img-4.jpg" alt = "">
                                      
                                    </div>
                                </div>
                                <!--END / ITEM -->

                                <!--ITEM -->
                                <div class = "item-isotope  ground suite dining" style = "position: absolute; left: 66.6198%; top: 0px;">
                                    <div class = "gallery_item">
                                      
                                            <img src = "images/gallery/img-5.jpg" alt = "">
                                      
                                    </div>
                                </div>
                                <!--END / ITEM -->

                                <!--ITEM -->
                                <div class = "item-isotope ground bathroom dining" style = "position: absolute; left: 83.2748%; top: 0px;">
                                    <div class = "gallery_item">
                                        <a href = "#" class = "gallery-popup mfp-image" title = "Luxury Room view all">
                                            <img src = "images/gallery/img-6.jpg" alt = "">
                                        </a>
                                    </div>
                                </div>
                                <!--END / ITEM -->

                                <!--ITEM -->
                                <div class = "item-isotope ground suite dining" style = "position: absolute; left: 0%; top: 157px;">
                                    <div class = "gallery_item">
                                      
                                            <img src = "images/gallery/img-7.jpg" alt = "">
                                      
                                    </div>
                                </div>
                                <!--END / ITEM -->

                                <!--ITEM -->
                                <div class = "item-isotope bathroom suite dining" style = "position: absolute; left: 16.655%; top: 157px;">
                                    <div class = "gallery_item">
                                       
                                            <img src = "images/gallery/img-8.jpg" alt = "">
                                      
                                    </div>
                                </div>
                                <!--END / ITEM -->

                                <!--ITEM -->
                                <div class = "item-isotope bathroom suite dining" style = "position: absolute; left: 33.3099%; top: 157px;">
                                    <div class = "gallery_item">
                                      
                                            <img src = "images/gallery/img-9.jpg" alt = "">
                                      
                                    </div>
                                </div>
                                <!--END / ITEM -->

                                <!--ITEM -->
                                <div class = "item-isotope ground bathroom" style = "position: absolute; left: 49.9649%; top: 157px;">
                                    <div class = "gallery_item">
                                       
                                            <img src = "images/gallery/img-10.jpg" alt = "">
                                       
                                    </div>
                                </div>
                                <!--END / ITEM -->

                                <!--ITEM -->
                                <div class = "item-isotope ground bathroom suite " style = "position: absolute; left: 66.6198%; top: 157px;">
                                    <div class = "gallery_item">
                                      
                                            <img src = "images/gallery/img-11.jpg" alt = "">
                                     
                                    </div>
                                </div>
                                <!--END / ITEM -->

                                <!--ITEM -->
                                <div class = "item-isotope ground bathroom" style = "position: absolute; left: 83.2748%; top: 157px;">
                                    <div class = "gallery_item">
                                      
                                            <img src = "images/gallery/img-12.jpg" alt = "">
                                       
                                    </div>
                                </div>
                                <!--END / ITEM -->

                            </div>
                        </div>

                        <div class = "our-gallery text-center">
                            <a href = "gallery.php" class = "awe-btn awe-btn-default">BROWSE OUR GALLERY</a>
                        </div>

                    </div>
                    <!--GALLERY CONTENT -->

                </div>
            </section>
            <?php include './footer.php';
            ?>
        </div>

        <!-- LOAD JQUERY -->
        <script type="text/javascript" src="js/lib/jquery-1.11.0.min.js"></script>
        <script type="text/javascript" src="js/lib/jquery-ui.min.js"></script>
        <script type="text/javascript" src="js/lib/bootstrap.min.js"></script>
        <script type="text/javascript" src="js/lib/bootstrap-select.js"></script>
        <script src="//maps.google.com/maps/api/js?key=AIzaSyAb2lfsiytHD7rMhBaAvJz2CKhk05uiIuE"></script>
        <script type="text/javascript" src="js/lib/jquery.themepunch.revolution.min.js"></script>
        <script type="text/javascript" src="js/lib/jquery.themepunch.tools.min.js"></script>
        <script type="text/javascript" src="js/lib/owl.carousel.js"></script>
        <script type="text/javascript" src="js/lib/jquery.appear.min.js"></script>
        <script type="text/javascript" src="js/lib/jquery.countTo.js"></script>
        <script type="text/javascript" src="js/lib/jquery.countdown.min.js"></script>
        <script type="text/javascript" src="js/lib/jquery.parallax-1.1.3.js"></script>
        <script type="text/javascript" src="js/lib/jquery.magnific-popup.min.js"></script>
        <script type="text/javascript" src="js/lib/SmoothScroll.js"></script>
        <!-- validate -->
        <script type="text/javascript" src="js/lib/jquery.form.min.js"></script>
        <script type="text/javascript" src="js/lib/jquery.validate.min.js"></script>
        <!-- Custom jQuery -->
        <script type="text/javascript" src="js/scripts.js"></script>
    </body>
</html>