<?php
include_once(dirname(__FILE__) . '/class/include.php');

$id = '';
if (isset($_GET['id'])) {
    $id = $_GET['id'];
}
$PRODUCT_TYPE_OBJ = new ProductType(null);
$PRODUCT_TYPEOBJ = new ProductType($id);
$PRODUCT_TYPE_PHOTOS_OBJ = new ProductTypePhotos(null);
?>
<!Doctype html>
<html lang="en-gb" class="no-js"> 

    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Ariyapala Mask Museum | Ariyapala Traditional Masks | Ariyapala Mask in Ambalangoda</title>
        <meta name="description" content="The art of Sri Lankan Masks was existing from time immemorial. Mask carving is a local tradition in the southern coastal region in Sri Lanka. Ambalangoda is well known for traditional masks carvings and masks dancing. The present institution named ‘Ariyapala & Sons’ passing through their fifth generation of traditional masks carving and dancing is a very popular cultural center in Ambalangoda. It was named after “Ariyapala Wijesuriya Gurunnanse”, one of the greatest master craftsmen in Sri Lanka.">
            <meta name="keywords" content="mask in ambalangoda, ariyapala & sons mask museum ambalangoda, traditional mask in sri lanka, traditional mask in ambalangoda ">
        <meta name="author" content="">

        <link rel="icon" type="image/png" sizes="16x16" href="images/icons/favicon.ico">
        <link rel="icon" type="image/png" sizes="16x16" href="images/icons/apple-icon.png">
  

        <link id="default-css" rel="stylesheet" href="style.css" type="text/css" media="all" />

        <link href="css/animations.css" rel="stylesheet" type="text/css" media="all" />
        <link id="shortcodes-css" href="css/shortcodes.css" rel="stylesheet" type="text/css" media="all" />
        <link id="skin-css" href="skins/red/style.css" rel="stylesheet" media="all" />
        <link href="css/isotope.css" rel="stylesheet" type="text/css" media="all" />
        <link href="css/prettyPhoto.css" rel="stylesheet" type="text/css" />
        <link href="css/pace.css" rel="stylesheet" type="text/css" />
        <link rel="stylesheet" href="css/responsive.css" type="text/css" media="all" />
        <link id="light-dark-css" href="dark/dark.css" rel="stylesheet" media="all" />

        <link rel="stylesheet" href="css/font-awesome.min.css" type="text/css" />

        <script src="js/modernizr.js"></script>
    </head>
    <body>
        <div class="loader-wrapper">
            <div id="large-header" class="large-header">
                <h1 class="loader-title"><span>Ariyapala</span> Mask Museum</h1>
            </div>
        </div>

        <div class="wrapper">
            <div class="slider-container ">
                <div class="slider fullwidth-section parallax"></div>
            </div>
           
            <div class="inner-wrapper">
                <?php include './header.php'; ?>
                <div id="main">
                    <section id="primary" class="content-full-width"> 
                        <div class="dt-sc-hr-invisible-small"></div>
                        <div class="fullwidth-section">
                            <div class="container">
                                <div class="main-title animate" data-animation="pullDown" data-delay="100">
                                    <h2 class="aligncenter"> We are </h2>
                                    <p>Fifth generation of traditional masks carving and dancing</p>
                                </div>
                                <div class="about-section">
                                    <div class="dt-sc-one-half column first">
                                        <img src="images/about-bg.jpg" title="" alt="ariyapala mask amblangoda">
                                    </div>
                                    <div class="dt-sc-one-half column">
                                        <h3 class="animate" data-animation="fadeInLeft" data-delay="200"> About us</h3>
                                        <p>The art of Sri Lankan Masks was existing from time immemorial. Mask carving is a local tradition in the southern coastal region in Sri Lanka. Ambalangoda is well known for traditional masks carvings and masks dancing. The present institution named ‘Ariyapala & Sons’ passing through their fifth generation of traditional masks carving and dancing is a very popular cultural center in Ambalangoda. It was named after “Ariyapala Wijesuriya Gurunnanse”, one of the greatest master craftsmen in Sri Lanka.</p>
                                        <h3 class="animate" data-animation="fadeInLeft" data-delay="300"> History of Museum</h3>
                                        <p> This museum is designed to introduce into the richness of the mask tradition of Ambalangoda and to strengthen this cultural heritage. The museum, the workshop and the small library (containing all available anthropological literature on masks performances) may serve as a centre for traditional arts and crafts and for research as well.</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="clear"></div>
                        <div class="dt-sc-hr-invisible-small"></div>
                        <div class="clear"></div>




                        <div class=" fullwidth-section bg" >
                            <div class="container">
                                <div class="main-title animate" data-animation="pullDown" data-delay="100" style="margin-top: 30px;">
                                    <h2 class="aligncenter"> Product </h2>
                                    <p>Tell mocking stories of traditional Sri Lankan colonial life. </p>
                                </div>
                            </div>

                            <?php
                            $PRODUCT_TYPE = $PRODUCT_TYPE_OBJ->all();
                            foreach ($PRODUCT_TYPE as $key => $product_type) {
                                if (($key % 2) === 0) {
                                    ?>

                                    <div class="blog-section">
                                        <article class="blog-entry">
                                            <div class="entry-thumb">
                                                <ul class="blog-slider">
                                                    <?php
                                                    $PHOTO = $PRODUCT_TYPE_PHOTOS_OBJ->getProductTypePhotosById($product_type["id"]);
                                                    foreach ($PHOTO as $key => $photos) {
                                                        ?>
                                                        <li> <img src="upload/product-type/gallery/<?php echo $photos["image_name"]; ?>" alt="" title=""> </li>
                                                        <?php
                                                    }
                                                    ?>
                                                </ul>
                                            </div>
                                            <div class="entry-details">
                                                <div class="entry-title">
                                                    <h3><a href=""><?php echo $product_type["name"]; ?></a></h3>
                                                </div>
                                                <div class="entry-body">
                                                    <?php echo $product_type["description"]; ?>
                                                </div>
                                                <a class="type1 dt-sc-button small" href="product.php?id=<?php echo $product_type["id"]; ?>">View Product <i class="fa fa-angle-right"></i></a>
                                            </div>
                                        </article>
                                    </div>
                                    <?php
                                } else {
                                    ?>


                                    <div class="blog-section">
                                        <article class="blog-entry type2">
                                            <div class="entry-details">
                                                <div class="entry-title">
                                                    <h3><a href=""><?php echo $product_type["name"]; ?></a></h3>
                                                </div>
                                                <div class="entry-body">
                                                    <?php echo $product_type["description"]; ?>
                                                </div>
                                                <a class="type1 dt-sc-button small" href="product.php?id=<?php echo $product_type["id"]; ?>">View Product<i class="fa fa-angle-right"></i></a>
                                            </div>
                                            <div class="entry-thumb">
                                                <ul class="blog-slider">
                                                    <?php
                                                    $PHOTO = $PRODUCT_TYPE_PHOTOS_OBJ->getProductTypePhotosById($product_type["id"]);
                                                    foreach ($PHOTO as $key => $photos) {
                                                        ?>
                                                        <li> <img src="upload/product-type/gallery/<?php echo $photos["image_name"]; ?>" alt="" title=""> </li>
                                                        <?php
                                                    }
                                                    ?>   </ul>
                                            </div>
                                        </article>
                                    </div>
                                    <?php
                                }
                            }
                            ?>



                        </div>
                        <div class="fullwidth-section">
                            <div class="container">
                                <div class="main-title animate" data-animation="pullDown" data-delay="100" style="margin-top: 30px;">
                                    <h2 class="aligncenter">  Feedbacks </h2>
                                    <p> Keep in touch with uss </p>
                                </div>
                                <div class="blog-slider">
                                    <div class="post-author-details">
                                        <div class="entry-author-image">
                                            <img src="images/authour.png" alt="" title="" />
                                        </div>
                                        <div class="author-title">
                                            <h5>James Dean</h5>
                                            <span>Garland, TX - United States</span>
                                           
                                        </div>
                                        <div class="author-desc">
                                            <p>As we were staying locally the Mask Museum was on our agenda to visit.There is a large shop attached to the Museum with a great variety of wood carvings and masks to choose from, Prices seem on the high side but then you are paying for a unique handmade product.</p>
                                        </div>
                                    </div>
                                    <div class="post-author-details">
                                        <div class="entry-author-image">
                                            <img src="images/authour-3.png" alt="" title="" />
                                        </div>
                                        <div class="author-title">
                                            <h5>Simon </h5>
                                            <span>Agde, France</span>
                                         
                                        </div>
                                        <div class="author-desc">
                                            <p>There a two parts, one where you can see and experience the various steps how masks are designed and crafted. Very interesting, and the skills of some of the workers are worth watching it.</p>
                                        </div>
                                    </div>
                                    <div class="post-author-details">
                                        <div class="entry-author-image">
                                            <img src="images/authour-1.png" alt="" title="" />
                                        </div>
                                        <div class="author-title">
                                            <h5>Eilat</h5>
                                            <span>Newcastle upon Tyne - United Kingdom</span>
                                          
                                        </div>
                                        <div class="author-desc">
                                            <p>You get to see different type of mask, very unique to Srilankan Culture. The guide at the museum is not very knowledgeable. However, the museum is well designed and maintained</p>
                                        </div>
                                    </div>
                                    <div class="post-author-details">
                                        <div class="entry-author-image">
                                            <img src="images/authour-2.png" alt="" title="" />
                                        </div>
                                        <div class="author-title">
                                            <h5>srishkalyan</h5>
                                            <span>Bengaluru - India</span>
                                          
                                        </div>
                                        <div class="author-desc">
                                            <p>Excellent to see the vast array of masks ,colours and sizes to suite everyones budget.Also plenty of gift ideas well worth a visit.</p>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>



                        <div class="clear"></div>

                        <div class="dt-sc-hr-invisible-small"></div>
                    </section>
                    <?php include './footer.php'; ?>
                </div>
            </div>
        </div>

        <script src="js/jquery-1.11.2.min.js" type="text/javascript"></script>
        <script src="js/jquery.inview.js" type="text/javascript"></script>
        <script src="js/jquery.viewport.js" type="text/javascript"></script>
        <script type="text/javascript" src="js/jquery.isotope.min.js"></script>
        <script src="js/jsplugins.js" type="text/javascript"></script>
        <script src="js/jquery.prettyPhoto.js" type="text/javascript"></script>
        <script src="js/jquery.validate.min.js" type="text/javascript"></script>
        <script src="js/jquery.tipTip.minified.js" type="text/javascript"></script>
        <script type="text/javascript" src="js/jquery.bxslider.min.js"></script>
        <script src="js/controlpanel.js" type="text/javascript"></script>
        <script src="js/custom.js"></script>

    </body>

</html>
