<?php
include './class/include.php';
if (!isset($_SESSION)) {
    session_start();
}
$disabled = '';
if (!isset($_SESSION["shopping_cart"])) {
    $disabled = 'disabled';
}
$_SESSION["back_url"] = '';
if (!Customer::authenticate()) {
    $_SESSION["back_url"] = 'checkout';
    redirect('signin.php');
}
if (!isset($_SESSION["shopping_cart"]) || empty($_SESSION["shopping_cart"])) {
    redirect('cart.php');
}
$CUSTOMER = new Customer($_SESSION['id']);
$DISTRICT = new District($CUSTOMER->district);

$delivery_charge = DefaultData::getDeliveryCharges();

$paypal_url = 'https://www.paypal.com/cgi-bin/webscr';
// $paypal_url = 'https://www.sandbox.paypal.com/cgi-bin/webscr';
$paypal_email = 'serandibgems@gmail.com';
?>
<!doctype html>
<html class="no-js" lang="zxx">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>CheckOut || Pramudi Gems & Jewellery</title>
    <meta name="robots" content="noindex, follow" />
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Favicon -->
    <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png">

    <!-- CSS
            ============================================ -->
    <!-- google fonts -->
    <link href="https://fonts.googleapis.com/css?family=Lato:300,300i,400,400i,700,900" rel="stylesheet">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="assets/css/vendor/bootstrap.min.css">
    <!-- Pe-icon-7-stroke CSS -->
    <link rel="stylesheet" href="assets/css/vendor/pe-icon-7-stroke.css">
    <!-- Font-awesome CSS -->
    <link rel="stylesheet" href="assets/css/vendor/font-awesome.min.css">
    <!-- Slick slider css -->
    <link rel="stylesheet" href="assets/css/plugins/slick.min.css">
    <!-- animate css -->
    <link rel="stylesheet" href="assets/css/plugins/animate.css">
    <!-- Nice Select css -->
    <link rel="stylesheet" href="assets/css/plugins/nice-select.css">
    <!-- jquery UI css -->
    <link rel="stylesheet" href="assets/css/plugins/jqueryui.min.css">
    <!-- main style css -->
    <link href="control-panel/plugins/sweetalert/sweetalert.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="assets/css/style.css">
    <link href="contact-form/style.css" rel="stylesheet" type="text/css" />
    <link href="assets/css/responsive.css" rel="stylesheet" type="text/css" />
    <link href="contact-form/style.css" rel="stylesheet" type="text/css" />



</head>

<body class="checkout-page">
    <!-- sandbox -->
    <!-- <script src="https://www.paypal.com/sdk/js?client-id=Aak2W0UYKwKIe7z3oCmoSGMfelqR9oghNzZAU4Re_GAYJKu9fGiazKKM9dWuiM5VNh7vxnKO9lT9BTUc"></script> -->
    <!-- Live -->
    <script src="https://www.paypal.com/sdk/js?client-id=AdX7cfrLmkBhRIO3j332yGbv34xujomnSyOXA-2Np5W497TXY7XQSSNCVG3WBk_AgecEClSFhZHa4Ul-"></script>

    <?php include './header.php'; ?>
    <main>
        <!-- breadcrumb area start -->
        <div class="breadcrumb-area">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="breadcrumb-wrap">
                            <nav aria-label="breadcrumb">
                                <ul class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="./"><i class="fa fa-home"></i> Home</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">Checkout</li>
                                </ul>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="contact-area section-padding pb-0 mobile-section-index-about">
            <div class="container">
                <div class="row">
                    <?php
                    if (isset($_GET['status']) && $_GET['status'] == 'error') {
                    ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <strong>Sorry!</strong> Your transaction was not successful.
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    <?php
                    } elseif (isset($_GET['status']) && $_GET['status'] == 'cancel') {
                    ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <strong>Canceled!</strong> Your PayPal transaction has been canceled.
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    <?php
                    } elseif (isset($_GET['status']) && $_GET['status'] == 'success') {
                    ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <strong>Success!</strong> Your PayPal transaction has been completed successfully.
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                        </div>
                    <?php
                    }
                    ?>
                    <form id="payments" action="<?php echo $paypal_url; ?>" method="post" class="contact-form">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="contact-message">
                                    <h4 class="contact-title">Billing Details</h4>

                                    <div class="row">
                                        <div class="col-lg-6 col-md-6 col-sm-12">

                                            <input type="text" name="contact_no_1" id="txtContactNo" placeholder="Contact Number" value="<?php echo $CUSTOMER->phone_number; ?>" class="form-control input-lg">
                                        </div>
                                        <div class="col-lg-6 col-md-6 col-sm-12">
                                            <input type="text" name="contact_no_2" id="txtContactNo2" placeholder="Additional Contact Number" class="form-control">
                                        </div>
                                        <div class="col-lg-6 col-md-6 col-sm-12">
                                            <input type="text" name="address" id="txtAddress" placeholder="Address *" value="<?php echo $CUSTOMER->address; ?>" class="form-control">
                                        </div>
                                        <div class="col-lg-6 col-md-6 col-sm-12">
                                            <select name="district" id="district" class="form-control">
                                                <option>--Select State--</option>
                                                <?php
                                                foreach (District::all() as $district) {
                                                    if ($district['id'] == $CUSTOMER->district) {
                                                ?>
                                                        <option value="<?php echo $district['id']; ?>" selected dis-name="<?php echo $district['name']; ?>"><?php echo $district['name']; ?></option>
                                                    <?php
                                                    } else {
                                                    ?>
                                                        <option value="<?php echo $district['id']; ?>" dis-name="<?php echo $district['name']; ?>"><?php echo $district['name']; ?></option>
                                                <?php
                                                    }
                                                }
                                                ?>
                                            </select>
                                        </div>
                                        <div class="col-lg-12 col-md-12 col-sm-12">
                                            <textarea cols="6" rows="5" id="txtOrderNote" name="txtOrderNote" class="form-control" placeholder="Note about your order, Special note for delevery !"></textarea>
                                        </div>







                                    </div>

                                    <div class="col-sm-12 mt-20">
                                        <div id="dismessage" align="center"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="your-order">
                                    <h4 class="contact-title">Your Order</h4>
                                    <div class="your-order-table table-responsive">
                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th class="cart-product-name">Product</th>
                                                    <th class="cart-product-total">Total</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                $tot = 0;
                                                $items = '';
                                                if (isset($_SESSION["shopping_cart"])) {
                                                    foreach ($_SESSION["shopping_cart"] as $product) {

                                                        $PRODUCT = new Product($product['product_id']);
                                                        $name =  $product["product_name"];

                                                        $price = $product['product_quantity'] * $product['product_price'];
                                                        $tot += $price;
                                                        $items = '';
                                                        if (empty($items)) {
                                                            $items .= $name;
                                                        } else {
                                                            $items .= ', ' . $name;
                                                        }
                                                ?>
                                                        <tr class="cart_item">
                                                            <td class="cart-product-name"> <?= $name; ?><strong class="product-quantity">
                                                                    × <?= $product['product_quantity']; ?></strong></td>
                                                            <td class="cart-product-total text-right"><span class="amount">US $ <?= number_format($price, 2); ?></span></td>
                                                        </tr>
                                                    <?php
                                                    }
                                                } else {
                                                    ?>
                                                    <li><span class="order-middle-left">Your cart is empty</span></li>
                                                <?php
                                                }
                                                ?>
                                            </tbody>
                                            <tfoot>
                                                <?php
                                                $grand_total = $tot + $delivery_charge;
                                                ?>
                                                <tr class="cart-subtotal">
                                                    <th>Cart Subtotal</th>
                                                    <td class="text-right"><span class="amount">US $ <?= number_format($tot, 2); ?></span></td>
                                                </tr>
                                                <tr class="cart-subtotal">
                                                    <th>Delivery Charges</th>
                                                    <td class="text-right"><span class="amount delivery_charges">US $ <?= number_format($delivery_charge, 2); ?></span></td>
                                                </tr>
                                                <tr class="order-total">
                                                    <th>Order Total</th>
                                                    <td class="text-right"><strong><span class="amount total_amount">US $ <?= number_format($grand_total, 2); ?></span></strong></td>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                    <div class="payment-method">
                                        <div class="payment-accordion">
                                            <div id="accordion agree-check-box" class="hidden">
                                                <label class="checkbox-container">Click here to indicate that you have read and agree to the <a href="terms-and-conditions.php" target="_blank" class="text-danger">terms and conditions</a>.
                                                    <input type="checkbox" name="agree" id="agree"><span class="checkmark">
                                                    </span>
                                                </label>
                                            </div>
                                            <div class="order-button-payment">
                                                <input name="sub_amount" id="sub_total_amount" type="hidden" value="<?= $grand_total; ?>" class="payment">
                                                <input name="amount" id="total_amount" type="hidden" value="<?= $grand_total; ?>" class="payment">
                                                <input type="hidden" name="delivery_charges" id="delivery_charges" value="<?= $delivery_charge; ?>">
                                                <!-- <input value="Place order" id="place_order" type="button"> -->


                                                <!-- Paypal business test account email id so that you can collect the payments. -->
                                                <input type="hidden" name="business" value="<?php echo $paypal_email; ?>">
                                                <!-- Buy Now button. -->
                                                <input type="hidden" name="cmd" value="_xclick">
                                                <!-- Details about the item that buyers will purchase. -->
                                                <input type="hidden" name="item_name" value="<?= $items; ?>">
                                                <input type="hidden" name="item_number" id="current_order_id" value="">
                                                <input type="hidden" name="amount" value="<?= $grand_total; ?>">
                                                <input type="hidden" name="currency_code" value="USD">
                                                <!-- URLs -->
                                                <!-- <input type='hidden' name='cancel_return' value='https://localhost/pramudi-gems/cancel.php'>
                                                <input type='hidden' name='return' value='https://localhost/pramudi-gems/success.php'>
                                                <input type='hidden' name='notify_url' value='https://localhost/pramudi-gems/payments.php'> -->
                                                <input type='hidden' name='cancel_return' value='https://pramudigems.com/checkout.php?status=cancel'>
                                                <input type='hidden' name='return' value='https://pramudigems.com/payments1.php'>
                                                <input type='hidden' name='notify_url' value='https://pramudigems.com/payments1.php'>
                                                <input type="hidden" name="rm" value="2" />
                                                <!-- payment button. -->
                                                <!-- <input type="image" name="submit" border="0" src="https://www.paypalobjects.com/en_US/i/btn/btn_buynow_LG.gif" alt="PayPal - The safer, easier way to pay online"> -->
                                                <img alt="" border="0" width="1" height="1" src="https://www.paypalobjects.com/en_US/i/scr/pixel.gif">

                                                <input type="hidden" name="total_amount" id="total_amount" value="<?= $grand_total; ?>" />
                                                <input type="hidden" name="member" id="member" value="<?= $_SESSION['id']; ?>" />


                                                <div class="col-lg-6 col-md-6 col-sm-6 contact-btn form-btn">
                                                    <button class="btn btn-sqr" type="submit" id="place_order">Place order</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="map-area section-padding pb-0 mobile-section-index-about">

        </div>

    </main>

    <!-- Scroll to top start -->
    <div class="scroll-top not-visible">
        <i class=""><img src="assets/img/icon/gem-top.png"></i>
    </div>
    <!-- Scroll to Top End -->
    <?php include './footer.php'; ?>

    <!-- JS
    ============================================ -->

    <!-- Modernizer JS -->
    <script src="assets/js/vendor/modernizr-3.6.0.min.js"></script>
    <!-- jQuery JS -->
    <script src="assets/js/vendor/jquery-3.3.1.min.js"></script>
    <!-- Popper JS -->
    <script src="assets/js/vendor/popper.min.js"></script>
    <!-- Bootstrap JS -->
    <script src="assets/js/vendor/bootstrap.min.js"></script>
    <!-- slick Slider JS -->
    <script src="assets/js/plugins/slick.min.js"></script>
    <!-- Countdown JS -->
    <script src="assets/js/plugins/countdown.min.js"></script>
    <!-- Nice Select JS -->
    <script src="assets/js/plugins/nice-select.min.js"></script>
    <!-- jquery UI JS -->
    <script src="assets/js/plugins/jqueryui.min.js"></script>
    <!-- Image zoom JS -->
    <script src="assets/js/plugins/image-zoom.min.js"></script>
    <!-- Imagesloaded JS -->
    <script src="assets/js/plugins/imagesloaded.pkgd.min.js"></script>
    <!-- Instagram feed JS -->
    <script src="assets/js/plugins/instagramfeed.min.js"></script>
    <!-- mailchimp active js -->
    <script src="assets/js/plugins/ajaxchimp.js"></script>
    <!-- contact form dynamic js -->
    <script src="assets/js/plugins/ajax-mail.js"></script>
    <!-- google map api -->
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCfmCVTjRI007pC1Yk2o2d_EhgkjTsFVN8"></script>
    <!-- google map active js -->
    <script src="assets/js/plugins/google-map.js"></script>
    <!-- Main JS -->
    <script src="assets/js/main.js"></script>

    <script src="control-panel/plugins/sweetalert/sweetalert.min.js" type="text/javascript"></script>
    <script src="js/order.js" type="text/javascript"></script>
    <script src="js/add-to-cart.js" type="text/javascript"></script>

    <script>
        paypal.Buttons({

            createOrder: function(data, actions) {

                return actions.order.create({

                    purchase_units: [{

                        amount: {

                            value: '0.01'

                        }

                    }]

                });

            },

            onApprove: function(data, actions) {

                return actions.order.capture().then(function(details) {

                    alert('Transaction completed by ' + details.payer.name.given_name);

                });

            }

        }).render('#paypal-button-container'); // Display payment options on your web page
    </script>
</body>

</html>