<?php
include './class/include.php';
if (!isset($_SESSION)) {
    session_start();
}
$disabled = '';
if (!isset($_SESSION["shopping_cart"])) {
    $disabled = 'disabled';
}
$_SESSION["back_url"] = '';
if (!Customer::authenticate()) {
    $_SESSION["back_url"] = 'checkout';
    redirect('sign-in.php');
}
if (!isset($_SESSION["shopping_cart"]) || empty($_SESSION["shopping_cart"])) {
    redirect('cart.php');
}
$CUSTOMER = new Customer($_SESSION['id']);
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="shortcut icon" type="image/x-icon" href="assets/magnoliya logo.png"/>
    <link href="https://fonts.googleapis.com/css2?family=Manrope:wght@200;300;400;500;600;700;800&amp;display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Kaushan+Script&amp;display=swap" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="assets/css/bootstrap.min.css" />
    <link rel="stylesheet" type="text/css" href="assets/css/animate.css" />
    <link rel="stylesheet" type="text/css" href="assets/css/bootstrap.min.css" />
    <link rel="stylesheet" type="text/css" href="assets/css/chosen.min.css" />
    <link rel="stylesheet" type="text/css" href="assets/css/font-awesome.min.css" />
    <link rel="stylesheet" type="text/css" href="assets/css/pe-icon-7-stroke.css" />
    <link rel="stylesheet" type="text/css" href="assets/css/jquery.scrollbar.css" />
    <link rel="stylesheet" type="text/css" href="assets/css/lightbox.min.css" />
    <link rel="stylesheet" type="text/css" href="assets/css/magnific-popup.css" />
    <link rel="stylesheet" type="text/css" href="assets/css/slick.min.css" />
    <link rel="stylesheet" type="text/css" href="assets/fonts/flaticon.css" />
    <link rel="stylesheet" type="text/css" href="assets/css/megamenu.css" />
    <link rel="stylesheet" type="text/css" href="assets/css/dreaming-attribute.css" />
    <link rel="stylesheet" type="text/css" href="control-panel/plugins/sweetalert/sweetalert.css" />
    <link rel="stylesheet" type="text/css" href="assets/css/style.css" />
    <title>Magnoliya | Checkout</title>
</head>

<body>

    <!-- Start Header -->
    <?php include './header.php'; ?>
    <!-- End Header -->

    <div class="banner-wrapper has_background">
        <img src="assets/images/banner-for-all2.jpg" class="img-responsive attachment-1920x447 size-1920x447" alt="img">
        <div class="banner-wrapper-inner">
            <h1 class="page-title">Checkout</h1>
            <div role="navigation" aria-label="Breadcrumbs" class="breadcrumb-trail breadcrumbs">
                <ul class="trail-items breadcrumb">
                    <li class="trail-item trail-begin"><a href="./"><span>Home</span></a></li>
                    <li class="trail-item trail-end active"><span>Checkout</span>
                    </li>
                </ul>
            </div>
        </div>
    </div>
    <main class="site-main  main-container no-sidebar">
        <div class="container">
            <div class="row">
                <div class="main-content col-md-12">
                    <div class="page-main-content">
                        <div class="lynessa">
                            <div class="lynessa-notices-wrapper"></div>
                            <form name="checkout" method="post" class="checkout lynessa-checkout" action="#" enctype="multipart/form-data" novalidate="novalidate">
                                <div class="col2-set" id="customer_details">
                                    <div class="col-1">
                                        <div class="lynessa-billing-fields">
                                            <h3>Billing details</h3>
                                            <div class="lynessa-billing-fields__field-wrapper">
                                                <p class="form-row form-row-wide validate-required" id="billing_last_name_field" data-priority="20">
                                                    <label for="contact_no_1" class="">Contact Number&nbsp;<abbr class="required" title="required">*</abbr></label>
                                                    <span class="lynessa-input-wrapper">
                                                        <input type="text" class="input-text " name="contact_no_1" id="txtContactNo" placeholder="" value="<?= $CUSTOMER->phone_number; ?>" autocomplete="family-name">
                                                    </span>
                                                </p>
                                                <p class="form-row form-row-wide" id="billing_company_field" data-priority="30">
                                                    <label for="contact_no_2" class="">Additional Contact Number&nbsp;<span class="optional">(optional)</span></label>
                                                    <span class="lynessa-input-wrapper">
                                                        <input type="text" class="input-text " name="contact_no_2" id="txtContactNo2" placeholder="" value="" autocomplete="organization">
                                                    </span>
                                                </p>
                                                <p class="form-row form-row-wide" id="billing_company_field" data-priority="30">
                                                    <label for="address" class="">Address&nbsp;<span class="required" title="required">*</span></label>
                                                    <span class="lynessa-input-wrapper">
                                                        <input type="text" class="input-text " name="address" id="txtAddress" placeholder="" value="<?= $CUSTOMER->address; ?>" autocomplete="organization">
                                                    </span>
                                                </p>
                                                <p class="form-row form-row-wide address-field update_totals_on_change validate-required" id="billing_country_field" data-priority="40">
                                                    <label for="district" class="">District&nbsp;<abbr class="required" title="required">*</abbr></label>
                                                    <span class="lynessa-input-wrapper">
                                                        <select name="district" id="district" class="country_to_state country_select" autocomplete="district" tabindex="-1" aria-hidden="true">
                                                            <option value="">Select a district</option>
                                                            <?php
                                                            foreach (District::all() as $district) {
                                                            ?>
                                                                <option value="<?= $district['id']; ?>" dis-name="<?= $district['name']; ?>"><?= $district['name']; ?></option>
                                                            <?php
                                                            }
                                                            ?>
                                                        </select>
                                                    </span>
                                                </p>
                                                <p class="form-row form-row-wide address-field update_totals_on_change validate-required" id="billing_country_field" data-priority="40">
                                                    <label for="city" class="">City&nbsp;<abbr class="required" title="required">*</abbr></label>
                                                    <span class="lynessa-input-wrapper">
                                                        <select name="city" id="city" class="country_to_state country_select" autocomplete="city" tabindex="-1" aria-hidden="true">
                                                            <option value="">Select a city</option>
                                                        </select>
                                                    </span>
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-2">
                                        <div class="lynessa-shipping-fields">
                                        </div>
                                        <div class="lynessa-additional-fields">
                                            <h3>Additional information</h3>
                                            <div class="lynessa-additional-fields__field-wrapper">
                                                <p class="form-row notes" id="order_comments_field" data-priority="">
                                                    <label for="txtOrderNote" class="">Order notes&nbsp;<span class="optional">(optional)</span></label>
                                                    <span class="lynessa-input-wrapper">
                                                        <textarea name="txtOrderNote" class="input-text " id="txtOrderNote" placeholder="Notes about your order, e.g. special notes for delivery." rows="2" cols="5"></textarea>
                                                    </span>
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <h3 id="order_review_heading">Your order</h3>
                                <div id="order_review" class="lynessa-checkout-review-order">
                                    <table class="shop_table lynessa-checkout-review-order-table">
                                        <thead>
                                            <tr>
                                                <th class="product-name">Product</th>
                                                <th class="product-total">Total</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $tot = 0;
                                            $items = '';
                                            if (isset($_SESSION["shopping_cart"])) {
                                                foreach ($_SESSION["shopping_cart"] as $product) {

                                                    $PRODUCT = new Product($product['product_id']);
                                                    $name =  $product["product_name"];

                                                    $price = $product['product_quantity'] * $product['product_price'];
                                                    $tot += $price;
                                                    $items = '';
                                                    if (empty($items)) {
                                                        $items .= $name;
                                                    } else {
                                                        $items .= ', ' . $name;
                                                    }
                                            ?>
                                                    <tr class="cart_item">
                                                        <td class="product-name"> <?= $name; ?><strong class="product-quantity">
                                                                × <?= $product['product_quantity']; ?></strong></td>
                                                        <td class="product-total"><span class="lynessa-Price-amount amount"><span class="lynessa-Price-currencySymbol">Rs. </span><?= number_format($price, 2); ?></span></td>
                                                    </tr>
                                                <?php
                                                }
                                            } else {
                                                ?>
                                                <tr class="cart_item">
                                                    <td class="product-name">Your cart is empty</td>
                                                </tr>
                                            <?php
                                            }
                                            ?>
                                        </tbody>
                                        <tfoot>
                                            <tr class="cart-subtotal">
                                                <th>Subtotal</th>
                                                <td><span class="lynessa-Price-amount amount"><span class="lynessa-Price-currencySymbol">Rs. </span><?= number_format($tot, 2); ?></span></td>
                                            </tr>
                                            <tr class="cart-subtotal">
                                                <th>Delivery Charges</th>
                                                <td><span class="lynessa-Price-amount amount delivery_charges"><span class="lynessa-Price-currencySymbol">Rs. </span>0.00</span></td>
                                            </tr>
                                            <tr class="order-total">
                                                <th>Total</th>
                                                <td><strong><span class="lynessa-Price-amount amount total_amount"><span class="lynessa-Price-currencySymbol">Rs. </span><?= number_format($tot, 2); ?></span></strong>
                                                </td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                    <input type="hidden" name="lang" value="en">
                                    <div id="payment" class="lynessa-checkout-payment">
                                        <div class="form-row place-order">
                                            <div id="accordion agree-check-box" class="hidden check-padding">
                                                <label class="checkbox-container">Click here to indicate that you have read and agree to the <a href="terms-and-conditions.php" target="_blank" class="text-danger">terms and conditions</a>.
                                                    <input type="checkbox" name="agree" id="agree"><span class="checkmark">
                                                    </span>
                                                </label>
                                            </div>
                                            <input name="amount" id="sub_total_amount" type="hidden" value="<?= $tot; ?>" class="payment">
                                            <input name="amount" id="total_amount" type="hidden" value="<?= $tot; ?>" class="payment">
                                            <input type="hidden" name="delivery_charges" id="delivery_charges" value="0.00" />
                                            <input type="hidden" name="member" id="member" value="<?= $_SESSION['id']; ?>" />
                                            <button type="submit" class="button alt" name="lynessa_checkout_place_order" id="place_order" value="Place order" data-value="Place order">Place
                                                order
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <!-- Start Header -->
    <?php include './footer.php'; ?>
    <!-- End Header -->

   

    <a href="#" class="backtotop active">
        <i class="fa fa-angle-up"></i>
    </a>
    <script src="assets/js/jquery-1.12.4.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/chosen.min.js"></script>
    <script src="assets/js/countdown.min.js"></script>
    <script src="assets/js/jquery.scrollbar.min.js"></script>
    <script src="assets/js/lightbox.min.js"></script>
    <script src="assets/js/magnific-popup.min.js"></script>
    <script src="assets/js/slick.js"></script>
    <script src="assets/js/jquery.zoom.min.js"></script>
    <script src="assets/js/threesixty.min.js"></script>
    <script src="assets/js/jquery-ui.min.js"></script>
    <script src="assets/js/mobilemenu.js"></script>
    <script src="assets/js/functions.js"></script>
    <script src="control-panel/plugins/sweetalert/sweetalert.min.js"></script>
    <script src="js/add-to-cart.js"></script>
    <script src="js/order.js"></script>
    <script src="js/city.js"></script>
    <script src="js/delivery_charges.js"></script>
</body>

</html>