<!DOCTYPE html>
<?php
include './class/include.php';
$ACTIVITY_OBJ = new Activities(NULL);
?>
<html lang="en">
    <head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        
        <!-- TITLE -->
        <title>Chaaya Inn Hikkaduwa | Activities</title>

        <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
        <meta name="format-detection" content="telephone=no">
        <meta name="apple-mobile-web-app-capable" content="yes">
        <link rel="shortcut icon" href="images/favicon.png">

       
        <!-- GOOGLE FONT -->
        <link href='http://fonts.googleapis.com/css?family=Hind:400,300,500,600%7cMontserrat:400,700' rel='stylesheet' type='text/css'>
        <link href="https://fonts.googleapis.com/css?family=Hind:300,400,500,600,700" rel="stylesheet">

        <!-- CSS LIBRARY -->
        <link rel="stylesheet" type="text/css" href="css\lib\font-awesome.min.css">
        <link rel="stylesheet" type="text/css" href="css\lib\font-lotusicon.css">
        <link rel="stylesheet" type="text/css" href="css\lib\bootstrap.min.css">
        <link rel="stylesheet" type="text/css" href="css\lib\owl.carousel.css">
        <link rel="stylesheet" type="text/css" href="css\lib\jquery-ui.min.css">
        <link rel="stylesheet" type="text/css" href="css\lib\magnific-popup.css">
        <link rel="stylesheet" type="text/css" href="css\lib\settings.css">
        <link rel="stylesheet" type="text/css" href="css\lib\bootstrap-select.min.css">
        <link rel="stylesheet" type="text/css" href="css\helper.css">

        <!-- MAIN STYLE -->
        <link rel="stylesheet" type="text/css" href="css\style.css">

        <!--[if lt IE 9]>
            <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
            <script src="http://css3-mediaqueries-js.googlecode.com/svn/trunk/css3-mediaqueries.js"></script>
        <![endif]-->
    </head>

    <!--[if IE 7]> <body class="ie7 lt-ie8 lt-ie9 lt-ie10"> <![endif]-->
    <!--[if IE 8]> <body class="ie8 lt-ie9 lt-ie10"> <![endif]-->
    <!--[if IE 9]> <body class="ie9 lt-ie10"> <![endif]-->
    <!--[if (gt IE 9)|!(IE)]><!--> 
    <body> <!--<![endif]-->

        <!-- PRELOADER -->
        <!--    <div id="preloader">
                <span class="preloader-dot"></span>
            </div>-->
        <!-- END / PRELOADER -->

        <!-- PAGE WRAP -->
        <div id="page-wrap" class="bg-white-2">


            <?php include './header.php'; ?>


            <!-- SUB BANNER -->
            <section class="section-sub-banner bg-9">
                <div class="awe-overlay"></div>
                <div class="sub-banner">
                    <div class="container">
                        <div class="text text-center">
                            <h2>Activities</h2>
                            <p>Discover the best activities in Sri Lanka</p>
                        </div>
                    </div>

                </div>

            </section>
            <!-- END / SUB BANNER -->

            <!-- ABOUT -->
            <section class="section-about mt70">
                <div class="container">

                    <div class="about">
                        <?php
                        $ACTIVITIES = $ACTIVITY_OBJ->all();
                        foreach ($ACTIVITIES as $activity) {
                            ?>
                            <div class="col-md-4">
                                <div class="accomd-modations-room_1 mb20">

                                    <div class="img">
                                        <a href="view-activity.php?id=<?php echo $activity['id'] ?>"><img src="upload/activity/<?php echo $activity['image_name'] ?>" alt="" ></a>
                                    </div>

                                    <div class="text">
                                        <h2><a href="view-activity.php?id=<?php echo $activity['id'] ?>"><?php echo $activity['title'] ?></a></h2>
                                        <p class="desc">
                                            <?php echo substr($activity['short_description'],0,120) ?>..
                                        </p>
                                        <div class="text-center mb20">

                                            <a href="view-activity.php?id=<?php echo $activity['id'] ?>" class="awe-btn awe-btn-default">VIEW DETAIL</a>
                                        </div>
                                    </div>

                                </div>

                            </div>

                            <?php
                        }
                        ?>
                    </div>

                </div>
            </section>
            <!-- END / ABOUT -->

            <?php include './footer.php'; ?>

        </div>
        <!-- END / PAGE WRAP -->


        <!-- LOAD JQUERY -->
        <script type="text/javascript" src="js/lib/jquery-1.11.0.min.js"></script>
        <script type="text/javascript" src="js/lib/jquery-ui.min.js"></script>
        <script type="text/javascript" src="js/lib/bootstrap.min.js"></script>
        <script type="text/javascript" src="js/lib/bootstrap-select.js"></script>
        <script src="https://maps.googleapis.com/maps/api/js?v=3.exp&signed_in=true"></script>
        <script type="text/javascript" src="js/lib/isotope.pkgd.min.js"></script>
        <script type="text/javascript" src="js/lib/jquery.themepunch.revolution.min.js"></script>
        <script type="text/javascript" src="js/lib/jquery.themepunch.tools.min.js"></script>
        <script type="text/javascript" src="js/lib/owl.carousel.js"></script>
        <script type="text/javascript" src="js/lib/jquery.appear.min.js"></script>
        <script type="text/javascript" src="js/lib/jquery.countTo.js"></script>
        <script type="text/javascript" src="js/lib/jquery.countdown.min.js"></script>
        <script type="text/javascript" src="js/lib/jquery.parallax-1.1.3.js"></script>
        <script type="text/javascript" src="js/lib/jquery.magnific-popup.min.js"></script>
        <script type="text/javascript" src="js/lib/SmoothScroll.js"></script>
        <script type="text/javascript" src="js/scripts.js"></script>
    </body>
</html>